---
name: auto-shorts-repurposer
description: Repurpose long-form video or audio into short-form clip plans with timestamps, hooks, captions, and packaging notes. Use when a user asks to turn a long video, podcast, or stream into Shorts, Reels, TikTok-style outputs, or highlight clips without publishing.
---

# Auto Shorts Repurposer

## Goal
Turn long-form media into a short-form clip plan with clear timestamps, captions, and platform-ready packaging notes.

## Best fit
- Use when the user provides a long video, livestream, or podcast and wants 3 to 20 short clips.
- Use when the user wants hooks, captions, titles, and thumbnail direction drafted for short platforms.
- Use when the user can provide brand tone, audience, and target platforms.

## Not fit
- Avoid when the user requests auto publishing or account access to post content.
- Avoid when the user lacks rights or consent to repurpose the source media.
- Avoid when the source has no usable audio or transcript and the user cannot provide one.

## Quick orientation
- `references/overview.md` for workflow and quality bar.
- `references/auth.md` for access and token handling.
- `references/endpoints.md` for optional integrations and templates.
- `references/webhooks.md` for async event handling.
- `references/ux.md` for intake questions and output formats.
- `references/troubleshooting.md` for common issues.
- `references/safety.md` for safety and privacy guardrails.

## Required inputs
- Source media file path or URL, plus any existing transcript.
- Target platforms and constraints (length range, aspect ratio, language).
- Desired clip count and focus topics.
- Brand tone, keywords, and banned topics.

## Expected output
- Clip shortlist with timestamps, hook lines, and rationale.
- Caption drafts and on-screen text per clip.
- Hashtag and title suggestions.
- Thumbnail brief or cover-frame suggestions.
- Optional cut list instructions for an editor.

## Operational notes
- Work from transcripts when possible and verify timestamps against the source.
- Prefer short, self-contained moments with a clear hook in the first 1 to 2 seconds.
- Deliver outputs as drafts only; do not publish or upload.

## Security notes
- Do not request account credentials or access tokens for posting.
- Avoid sharing source media beyond the user-provided context.

## Safe mode
- Analyze media and produce draft clip plans, captions, and metadata only.
- Use read-only tooling and keep outputs in local files when requested.

## Sensitive ops
- Publishing or uploading content is out of scope and must not be attempted.
