---
name: auto-logger
description: 自动记录日常活动、对话摘要、重要事件到 memory 目录。支持定时记录、事件触发记录、每日总结。
---

# Auto Logger - 自动记录技能

自动记录用户的日常活动、重要对话、决策和事件，形成持久的记忆文件。

## 触发条件

### 自动触发
- **会话结束时** - 自动总结本次会话的关键信息
- **定时任务** - 每小时/每天自动整理记忆
- **检测到重要信息** - 如用户明确说"记住这个"、"保存一下"

### 手动触发
- "记录一下"
- "记住这个"
- "保存到记忆"
- "今天做了什么"

## 记录内容分类

### 1. 对话摘要
- 用户的重要请求
- 完成的任务
- 用户的偏好和习惯
- 决策和结论

### 2. 事件日志
- 文件创建/修改
- 配置变更
- 任务执行结果
- 错误和问题

### 3. 时间线
- 按时间顺序记录活动
- 便于回溯和审计

## 文件结构

```
workspace/
├── memory/
│   ├── 2026-03-01.md       # 每日记忆文件
│   ├── 2026-03-02.md
│   └── ...
├── MEMORY.md                # 长期记忆（ curated ）
└── skills/auto-logger/
    └── SKILL.md            # 本技能说明
```

## 执行流程

### 1. 检测记录时机
```javascript
// 伪代码
if (userSays("记住" | "保存" | "记录")) {
    captureContext();
}

if (sessionEnding()) {
    summarizeSession();
}

if (scheduledTime()) {
    dailyReview();
}
```

### 2. 提取关键信息
- 识别用户意图
- 提取实体（人名、地点、时间、任务）
- 判断重要性等级

### 3. 写入记忆文件
- 创建/更新 `memory/YYYY-MM-DD.md`
- 格式化记录内容
- 添加时间戳和标签

### 4. 定期整理
- 每周回顾 daily 文件
- 提炼重要内容到 `MEMORY.md`
- 删除过期或无关信息

## 输出格式

### 每日记忆文件 (`memory/YYYY-MM-DD.md`)

```markdown
# 2026-03-01 记忆

## 📋 今日概要
- 会话数：X
- 重要事件：Y
- 完成任务：Z

## 🗣️ 对话记录

### 09:25 - 邮箱配置
- 用户提供 QQ 邮箱地址：2426758093@qq.com
- 提供授权码用于 SMTP 配置
- 已保存到 TOOLS.md 和 .env.ps1

### 09:38 - 信息同步要求
- 用户要求保存所有个人信息
- 要求形成 skills 实现自动记录
- 已创建 auto-logger 技能

## ✅ 完成任务
- [x] 配置 QQ 邮箱 SMTP
- [x] 创建环境变量脚本
- [x] 更新 USER.md
- [x] 创建用户偏好配置文档
- [x] 创建 auto-logger 技能

## 📝 重要决策
- 新闻简报改为每日邮件自动发送
- 所有配置信息集中保存到 TOOLS.md

## 🏷️ 标签
#邮箱配置 #技能创建 #自动记录 #新闻简报
```

### 长期记忆 (`MEMORY.md`)

```markdown
# 长期记忆

## 👤 用户信息
- 姓名：白凤
- 邮箱：2426758093@qq.com
- 位置：北京
- 时区：GMT+8

## 🎯 偏好
- 新闻简报：每日邮件，7 板块×10 条
- 沟通风格：直接、简洁
- 安全规则：危险操作需二次确认

## 📚 重要项目
- 新闻自动化系统（2026-03-01 启动）
- 自动记录系统（2026-03-01 创建）

## 🔧 配置摘要
- SMTP: smtp.qq.com:587
- 环境变量：.env.ps1
- 技能：daily-news-brief, auto-logger
```

## 定时任务配置

### 每小时记录
```bash
openclaw cron add --name "hourly-log" --cron "0 * * * *" --command "执行会话摘要记录"
```

### 每日整理（23:00）
```bash
openclaw cron add --name "daily-review" --cron "0 23 * * *" --command "整理今日记忆到 MEMORY.md"
```

### 会话结束时
在 AGENTS.md 或会话结束钩子中调用：
```javascript
onSessionEnd(() => {
    autoLogger.summarize();
});
```

## 重要性判断规则

### 高优先级（必须记录）
- 用户明确说"记住"、"保存"
- 配置信息（密码、密钥、邮箱等）
- 用户偏好和习惯
- 重要决策和结论
- 任务完成状态

### 中优先级（建议记录）
- 任务执行过程
- 文件创建/修改
- 错误和问题解决
- 用户反馈

### 低优先级（可选记录）
- 日常对话
- 临时查询
- 已解决的问题

## 隐私和安全

### 不记录的内容
- 用户的密码原文（只记录"已设置密码"）
- 敏感个人信息（身份证号、银行卡等）
- 私密对话内容

### 加密建议
- 敏感配置使用环境变量
- 授权码等只保存在本地文件
- 不上传到云端或分享

## 与其他技能协作

### daily-news-brief
- 记录新闻简报发送状态
- 记录用户反馈

### 其他技能
- 任务完成后自动记录
- 配置变更时自动记录

## 示例用法

### 用户说"记住这个"
```
用户：记住一下，我的邮箱是 2426758093@qq.com
助手：好的，已记录到 memory/2026-03-01.md
```

### 会话结束自动记录
```
[会话结束]
→ 自动提取关键信息
→ 写入 memory/2026-03-01.md
→ 更新任务状态
```

### 定时每日整理
```
[23:00 定时任务]
→ 读取 memory/2026-03-01.md
→ 提炼重要内容到 MEMORY.md
→ 生成每日总结
```

## 注意事项

1. **及时性** - 重要信息立即记录，不要等
2. **准确性** - 记录前确认信息正确
3. **简洁性** - 记录要点，不要冗长
4. **可检索** - 使用标签和分类便于查找
5. **安全性** - 敏感信息脱敏或加密

---

**创建日期：** 2026-03-01  
**用户：** 白凤  
**版本：** 1.0
