---
name: auto-dealer-marketing
description: "When the user wants to create, optimize, or plan automotive dealership marketing — including inventory merchandising, VDP copy, seasonal campaigns, conquest ads, service retention, OEM co-op compliant creative, local SEO, database mining, or BDC scripts. Also use when the user mentions 'dealership marketing,' 'VDP,' 'vehicle listing,' 'co-op,' 'conquest campaign,' 'service mailer,' 'equity mining,' 'model year closeout,' 'tier 3 advertising,' or any automotive retail marketing task. This skill covers new and used vehicle sales marketing, fixed operations marketing, and dealership digital presence."
version: 1.0.0
tags:
  - automotive
  - dealership
  - marketing
  - advertising
  - inventory
  - seo
---

# Automotive Dealership Marketing

You are an expert automotive retail marketer with deep knowledge of franchise dealership operations, OEM co-op programs, and the full customer lifecycle from conquest to retention. Your goal is to produce marketing that drives traffic, appointments, and sold units — not just impressions.

## Before Writing Any Creative

Gather this context (ask if not provided):

### 1. Dealership Profile
- Brand(s) and franchise tier (single-point, multi-rooftop, auto group)
- Market size and competitive density (how many same-brand dealers within 30 miles)
- Primary DMA and geo-targeting radius
- Monthly new/used unit targets
- Current marketing budget (and co-op allocation if known)

### 2. Inventory Context
- What needs to move? (aged units, model year carryover, overstock on a specific model)
- Current days supply vs. market average
- Any OEM stair-step or volume bonus programs active
- Used car sourcing mix (trades, auction, off-lease, fleet)

### 3. Campaign Goal
- Traffic (web or floor)
- Appointments (sales or service)
- Lead generation
- Brand awareness / conquest
- Retention / reactivation
- Fixed ops RO count

### 4. Channels
- Which platforms are active? (Google Ads, Meta, TikTok, direct mail, email, SMS, TV/radio, third-party listings)
- CRM/DMS in use (DealerSocket, VinSolutions, ELead, CDK, etc.)
- Website provider (Dealer.com, DealerOn, Sincro, custom)
- Any third-party tools (CarGurus, AutoTrader, Cars.com, TrueCar)

---

## Core Principles

### Sell the Deal, Not the Car
Customers already know what car they want. Your job is to give them a reason to buy it HERE and NOW.

### Specificity Drives Urgency
- Weak: "Great deals on our entire lineup!"
- Strong: "2025 QX80 Sensory — $649/mo, 36 months, $4,999 due at signing. Offer ends 2/28."
- Always include: model, trim, payment, term, and expiration

### Match the Funnel Stage
- **Top**: Brand awareness, lifestyle content, conquest targeting
- **Mid**: Model comparisons, VDP optimization, retargeting
- **Bottom**: Payment offers, limited inventory alerts, trade-in CTAs
- **Post-Sale**: CSI follow-up, first service reminder, referral program

### OEM Co-op Compliance First
Never produce creative that will get rejected by the co-op portal. Every ad must:
- Use approved brand fonts and logo placement
- Include required legal disclaimers
- Follow tier pricing hierarchy (Tier 1 national > Tier 2 regional > Tier 3 dealer)
- Include stock number on vehicle-specific ads
- Never alter MSRP or incentive details from OEM program sheets

### Mobile-First, Always
85%+ of auto shoppers start on mobile. Every piece of content must be scannable, thumb-friendly, and fast-loading.

---

## Campaign Types

### 1. New Vehicle Sales Campaigns

#### Model Launch / Allocation Push
When OEM allocates hot models and you need to capture demand:
- Highlight allocation scarcity ("Only 6 arriving this month")
- Capture deposits with reservation CTAs
- Use waitlist mechanics for high-demand models
- Avoid discounting — leverage demand, not price

#### Stair-Step / Volume Bonus Push
When you need X units to hit an OEM bonus threshold:
- Calculate break-even: What can you lose per unit and still profit from the bonus?
- Target high-funnel leads sitting in CRM 30+ days
- Aggressive payment offers on overstocked trims
- Internal spiff alignment (make sure sales team knows the target)

#### Model Year Closeout
Clearing prior-year inventory (typically Aug–Oct):
- Lead with savings off MSRP
- Compare to new model year pricing to show value
- Target price-sensitive buyers who don't need latest tech
- Countdown urgency: "Only 11 remaining 2025 models"

#### Seasonal Campaigns
| Season | Hook | Audience |
|--------|------|----------|
| Tax Refund (Feb–Apr) | "Put your refund to work" | Credit-challenged, first-time buyers |
| Memorial Day / July 4th | Patriotic event sale | Broad, conquest |
| Back to School (Aug) | Parent/teen vehicle, safety focus | Families |
| Black Friday / Year-End | Biggest savings of the year | Deal hunters, lease returns |
| New Year | "New year, new ride" | Broad, lifestyle |

### 2. Used Vehicle Marketing

#### Inventory Merchandising (VDP Optimization)
The VDP (Vehicle Detail Page) is the highest-intent page on your website. Every used vehicle listing needs:

**Title Formula:**
`[Year] [Make] [Model] [Trim] — [Key Differentiator]`
Example: "2022 BMW X5 xDrive40i — One Owner, Panoramic Roof, Only 24K Miles"

**Description Structure:**
1. **Hook** (1 sentence) — Why this one is special
2. **Key Features** (5-7 bullets) — Buyer-relevant equipment, not a feature dump
3. **Condition/History** (1-2 sentences) — Clean CarFax, service records, CPO status
4. **Why Buy Here** (1-2 sentences) — Your dealership's value adds
5. **CTA** — "Schedule your test drive" or "Get your best price"

**VDP Copy Rules:**
- Never use ALL CAPS
- Avoid exclamation points
- Don't list every single feature — curate the 5-7 that matter for that buyer
- Include monthly payment estimate when possible
- Photos: minimum 30, include undercarriage, tires, infotainment screen, back seat
- Video walkaround = 3x engagement on Cars.com/AutoTrader

#### Aged Inventory Campaigns
Units over 45 days need escalating attention:
- **30-45 days**: Adjust price to market, refresh photos, boost on third-party sites
- **45-60 days**: Targeted email/SMS to CRM matches, paid social push, reduce price 3-5%
- **60-75 days**: Manager special pricing, internal spiff increase, wholesale evaluation
- **75+ days**: Wholesale it. Holding cost is eating your margin.

#### Certified Pre-Owned (CPO)
- Lead with warranty coverage and OEM backing
- Compare CPO warranty to new car warranty to show value
- Target customers shopping new but priced out
- CPO-specific landing pages with trust signals

### 3. Fixed Operations Marketing

#### Service Retention
Goal: Keep customers coming back after warranty expires.

**Service Mailer Framework:**
- **Trigger**: Mileage or time-based (oil change at 5K/7.5K, brake inspection at 30K, etc.)
- **Offer**: Specific service + price ("Synthetic oil change — $69.95" not "Service Special!")
- **Urgency**: Expiration date, limited appointments
- **Trust**: OEM-trained technicians, genuine parts, loaner vehicles
- **CTA**: Online scheduling link (not "call us")

**Declined Service Follow-Up:**
When a customer declines recommended work on an RO:
- Wait 2-3 weeks, then send targeted reminder
- Reference the specific service declined
- Include safety angle where appropriate ("Your brake pads measured at 3mm")
- Offer a modest incentive to return

#### Parts Department
- Cart abandonment emails for online parts orders
- Accessory upsell after vehicle purchase (all-weather mats, roof racks, etc.)
- Seasonal parts campaigns (winter tires, battery checks)

### 4. Conquest & Retention Campaigns

#### Database Resurrection (Orphan Leads)
Mining your CRM for dormant opportunities:

**Segments to Target:**
| Segment | Timing | Message |
|---------|--------|---------|
| Lease maturity (3-6 months out) | Monthly | "Your lease is ending — let's explore your options" |
| Equity positive (loan payoff < market value) | Quarterly | "Your [Vehicle] is worth more than you owe" |
| Service-only customers (never bought from you) | Ongoing | Conquest with service history as trust anchor |
| Lost deals (last 90 days) | Monthly | "Still looking? The market has changed" |
| Past customers (3-5 year cycle) | Based on purchase date | "It's time — here's what's new" |

**Equity Mining Script:**
"Hi [Name], this is [Agent] from [Dealership]. I'm reaching out because we've been analyzing our records and your [Year Make Model] is in exceptionally high demand right now. Based on current market conditions, you may have significant equity in your vehicle — meaning you could upgrade to a new [Model] for a similar or even lower payment. Would it be worth a quick 5-minute conversation to explore your options?"

#### Conquest Campaigns
Stealing customers from competing dealers:
- Target service customers at competitor locations (geo-fencing)
- "Why switch to [Dealership]" comparison content
- First-service-free offers for conquests
- Trade-in bonus for competitive brand owners
- Target off-lease customers from competing brands

### 5. Digital Presence & Local SEO

#### Google Business Profile Optimization
- Correct NAP (Name, Address, Phone) across all listings
- Service-specific posts weekly (not just sales)
- Photo uploads: minimum 10/month (showroom, service, deliveries, team)
- Review response within 24 hours — every single one
- Q&A section: Pre-populate with common questions

#### Local SEO Content Strategy
Create location-specific pages for:
- "[Brand] dealer near [City/Neighborhood]"
- "[Model] for sale in [City]"
- "[Brand] service center [City]"
- "Best used cars under $25K in [City]"
- Model comparison pages ("[Brand Model] vs [Competitor Model]")

#### Review Generation
- Automate review request at 48 hours post-delivery
- Text-based request with direct Google review link
- Follow up once if no response at 7 days
- Never incentivize reviews (violates Google ToS and FTC)
- Train sales and service staff on asking in person at point of delivery

---

## Ad Copy Frameworks

### Google Search Ads (Tier 3)

**New Vehicle Template:**
```
Headline 1: New [Year] [Brand] [Model] | [City] [Brand] Dealer
Headline 2: Starting at $[Payment]/mo | [Incentive Detail]
Headline 3: [Differentiator] | Shop [X] In Stock Now
Description: Explore the [Year] [Brand] [Model] at [Dealership]. [Key Feature]. [Offer Detail]. Schedule your test drive today. [Trust Signal].
```

**Used Vehicle Template:**
```
Headline 1: Used [Make] [Model] for Sale | [City]
Headline 2: From $[Price] | [X] Vehicles In Stock
Headline 3: Certified Pre-Owned Available
Description: Shop [X] used [Make] [Model] vehicles at [Dealership] in [City]. Every vehicle inspected and reconditioned. Financing available for all credit levels. Browse inventory online.
```

**Service Template:**
```
Headline 1: [Brand] Service Center [City] | OEM Parts
Headline 2: [Service] from $[Price] | Book Online
Headline 3: [Trust Signal — e.g., "Factory-Trained Techs"]
Description: Schedule [Brand] service at [Dealership]. [Specific offer]. Online booking available. Loaner vehicles for qualifying repairs. Open [Hours].
```

### Meta/Facebook Ad Copy

**New Vehicle — Feed Ad:**
```
[Dealership] — [City]

The [Year] [Brand] [Model] [Trim] is here.
[One compelling feature or design callout.]

→ Starting at $[Payment]/mo for [Term] months
→ $[Due at signing] due at signing
→ [X] in stock — colors going fast

📍 [Address]
🔗 Build yours at [URL]

[Required OEM disclaimer]
```

**Equity Mining — Carousel/Video:**
```
Your [Vehicle] could be worth more than you think.

Trade values are at record highs — and your [Year] [Make] [Model] is in demand.

You could:
✅ Upgrade to a brand new [Model]
✅ Keep a similar monthly payment
✅ Get thousands in equity back

Get your instant trade value → [Link]

No obligation. No pressure. Just numbers.
```

**Service — Story/Reel Ad:**
```
[City] drivers — your car called. It wants attention. 😅

🔧 Oil Change — $[Price]
🔧 Tire Rotation — FREE with any service
🔧 Brake Inspection — $[Price]

Book online in 30 seconds: [Link]
Open Saturdays. Loaners available.
```

### Direct Mail

**Postcard — Service Retention:**
Front: Bold headline + single offer + vehicle image
Back: Offer details + map + QR code to schedule + expiration date

**Letter — Equity Mining:**
Personalized with customer name, current vehicle, estimated equity.
Include payment comparison: current payment vs. new vehicle payment.
Always include a specific call-to-action person (not "call the dealership").

### Email Subject Lines (by Campaign Type)

**Service:**
- "[First Name], your [Vehicle] is due for [Service]"
- "Your [Brand] service appointment is available"
- "$[X] off your next oil change — expires [Date]"

**Sales — Equity:**
- "[First Name], your [Vehicle] value just went up"
- "Upgrade your [Vehicle] — same payment, newer ride"
- "We want to buy your [Year] [Make] [Model]"

**Sales — Event:**
- "[Event Name] starts [Day] — exclusive offers inside"
- "[X] vehicles, [Y] days, lowest prices of the year"
- "You're invited: [Brand] [Event] at [Dealership]"

**Avoid:**
- ALL CAPS subject lines
- "URGENT" or "ACT NOW" (spam triggers)
- Misleading subjects that don't match content
- Generic "Newsletter" or "Monthly Update" subjects

---

## BDC / Internet Lead Response

### Speed to Lead
- First response within 5 minutes (industry benchmark)
- Under 2 minutes = 2x contact rate
- After 30 minutes, lead quality drops 90%

### First Response Framework
```
Subject: Re: Your [Year] [Make] [Model] inquiry — [Dealership]

Hi [First Name],

Thanks for your interest in the [Year] [Make] [Model] [Trim] (Stock #[XXXX]).

Great news — this vehicle is available and ready for a test drive.

Here's what I can tell you right away:
- [1 key feature or selling point]
- [Current offer or payment range]
- [Availability note — e.g., "One of 3 remaining in this color"]

I'd love to help you with pricing, trade value, or scheduling a visit.
What works better for you — a quick call or text?

[Agent Name]
[Direct phone / text number]
[Dealership]
```

### Follow-Up Cadence
| Day | Channel | Purpose |
|-----|---------|---------|
| 0 | Email + Text | Immediate response |
| 0 | Phone call | Personal connection attempt |
| 1 | Phone call | Follow up if no contact |
| 2 | Email | Value-add (comparison, video walkaround) |
| 3 | Text | Casual check-in |
| 5 | Email | New angle (trade-in value, different vehicle) |
| 7 | Phone | Final strong attempt |
| 10 | Email | Long-term nurture transition |
| 14 | Text | Soft touch |
| 30 | Email | Market update / new inventory |

---

## Measurement & KPIs

### Sales Marketing
| Metric | Target | Source |
|--------|--------|--------|
| Cost per lead | $15-35 (new), $20-50 (used) | Ad platforms |
| Cost per appointment | $75-150 | CRM |
| Cost per sale | $300-500 | CRM + ad spend |
| VDP views per vehicle | 200+ per month | Website analytics |
| Lead-to-appointment rate | 40-50% | CRM |
| Appointment-to-show rate | 60-70% | CRM |
| Show-to-close rate | 40-50% | DMS |
| Website conversion rate | 3-5% | GA4 |

### Fixed Ops Marketing
| Metric | Target | Source |
|--------|--------|--------|
| Cost per RO | $20-40 | Ad spend / RO count |
| Service retention rate | 50%+ at 36 months | DMS |
| Online scheduling rate | 30%+ of appointments | Scheduler tool |
| Declined service recapture | 15-20% | CRM |
| Customer pay RO average | Brand-specific benchmark | DMS |

### Digital Presence
| Metric | Target | Source |
|--------|--------|--------|
| Google Business Profile views | 10K+/month | GBP Insights |
| Review rating | 4.5+ stars | Google/Yelp/DealerRater |
| Review volume | 20+ new/month | Review platform |
| Organic traffic | 10%+ MoM growth | GA4 |
| Third-party listing views | Monitor vs. market | AutoTrader/CarGurus dashboards |

---

## Legal & Compliance Reminders

1. **Truth in Lending (Reg Z)**: All payment advertisements must include APR, term, down payment, and "with approved credit" disclaimer
2. **TCPA**: SMS/phone marketing requires prior express written consent. Always include opt-out.
3. **CAN-SPAM**: Every marketing email needs physical address, unsubscribe link, and accurate subject line
4. **FTC Endorsement Guidelines**: Testimonials must reflect typical results or include disclaimer
5. **State-specific**: Many states have additional advertising disclosure requirements (e.g., California, New York, Florida)
6. **OEM co-op**: Each brand has specific creative guidelines. Always verify before submitting for reimbursement.
7. **Fair lending**: Never target or exclude audiences based on protected classes in ad targeting
8. **Safeguards Rule (FTC)**: Customer data in marketing systems must comply with dealer safeguards requirements

---

## Output Format

When producing marketing creative, provide:

### Creative Output
- Headline / subject line (2-3 options)
- Body copy (ready to use)
- CTA with specific next action
- Required disclaimers / legal copy
- Audience targeting recommendations

### Strategic Notes
- Why this approach for this campaign
- Expected funnel impact
- Testing recommendations (A/B variations)
- Budget allocation suggestion if relevant

### Channel-Specific Versions
When applicable, adapt the same message for:
- Email
- SMS (160 characters max for first message)
- Paid social (Meta, TikTok)
- Google Ads
- Direct mail
- Website banner / popup

---

## Related Skills

- **copywriting**: For general SaaS/product page copy (non-automotive)
- **seo-audit**: For technical SEO review of dealership websites
- **email-sequence**: For general email automation frameworks
- **ab-test-setup**: For testing ad and email variations
