# Visitor Tips — Austin

## Before You Arrive

### Best Time to Visit
| Season | Weather | Crowds | Prices | Verdict |
|--------|---------|--------|--------|---------|
| Spring (Mar-May) | Perfect 20-28C | High (SXSW in March) | High | Best weather, worst if SXSW week |
| Summer (Jun-Sep) | Brutal 38-42C | Lower | Lower | Only if you love AC and pools |
| Fall (Oct-Nov) | Perfect 18-28C | High (ACL, F1) | High | Best overall, watch event dates |
| Winter (Dec-Feb) | Mild 5-18C | Low | Lowest | Great value, cedar allergies |

### What to Pack
- **Sunscreen** — Even in winter, Texas sun is strong
- **Comfortable walking shoes** — SoCo and East Side are walkable
- **Layers** — AC is aggressive indoors (dress for 18C inside)
- **Hat/sunglasses** — Essential May-September
- **Allergy meds** — If visiting Dec-April, seriously

### Money
- **Credit cards accepted everywhere** — Cash rarely needed
- **Tipping expected:**
  - Restaurants: 18-22%
  - Bars: $1-2/drink or 18-20%
  - Rideshare: 15-20%
  - BBQ counter service: 15-20% (they work hard)

---

## Getting Around

### From the Airport (AUS)
- **Uber/Lyft**: $25-40 to downtown, 15-25 min
- **Airport Flyer (Bus 20)**: $1.25, 30-40 min to downtown
- **Rental car**: Available but often not needed for first visit

### Within Austin
- **Rideshare is dominant** — Most visitors don't need a car
- **Scooters everywhere** — Download Bird, Lime, Lyft apps
- **Walking** — Good in SoCo, Downtown, East Side
- **Biking** — Great along Lady Bird Lake trail
- **Public transit** — Exists but not efficient for tourists

### When You Need a Car
- Day trips (Hill Country, San Antonio)
- North Austin/Domain visits
- Staying in suburbs
- 4+ person groups (cheaper than Uber)

---

## Food & Drink Tips

### Breakfast Tacos
- **Yes, they're that good** — Start every day with them
- **Order with green salsa** — It's the local way
- **Best chains**: Tacodeli, Torchy's (accessible), Veracruz (best)
- **Don't sleep on gas station tacos** — Some are legendary

### BBQ Strategy
- **Don't wait at Franklin** unless you commit fully (8am arrival, 3-4 hour wait)
- **Alternatives equally good**: la Barbecue, Micklethwait, Interstellar
- **Terry Black's and Stiles Switch** have no lines and are excellent
- **Order**: Brisket (always), ribs, sausage. Sides are secondary.

### Happy Hour Culture
- **Common hours**: 4-7pm
- **Best deals**: Half-price apps, $5-7 drinks
- **Many restaurants participate** — Ask

### Late Night Eats
- **24 Diner** — Elevated diner food, 24 hours
- **Magnolia Cafe** — Austin institution, 24 hours
- **Kerbey Lane** — Pancakes at 3am
- **P. Terry's** — Fast food burgers, open late

---

## Live Music Tips

### Finding Shows
- **Do512.com** — Best event calendar
- **Austin Chronicle** — Weekly picks
- **Bandsintown** — If following specific artists

### Free Music
- **Most bars on East 6th** — Free before 10pm
- **Continental Club** — Often free early shows
- **C-Boy's Heart & Soul** — Blues/soul, accessible
- **Saxon Pub** — Songwriters, low/no cover

### Genres by Venue
| Genre | Go Here |
|-------|---------|
| Country/Honky Tonk | White Horse, Broken Spoke |
| Indie/Rock | Mohawk, Stubb's, Parish |
| Blues/Soul | Antone's, C-Boy's |
| Singer-Songwriter | Saxon Pub, Cactus Cafe |
| Electronic | Kingdom, Lanai |
| Jazz | Elephant Room, Parker Jazz Club |

### Tips
- Shows start earlier than you'd expect (often 8-9pm openers)
- Two-drink minimum at some seated venues
- Outdoor venues close early (noise ordinances)
- Always bring ID, even if you're clearly over 21

---

## Day Trips from Austin

### 1 Hour or Less
| Destination | Drive Time | Why Go |
|-------------|------------|--------|
| San Marcos | 35 min | Outlets, tubing on San Marcos River |
| Lockhart | 35 min | BBQ capital of Texas (Kreuz, Black's) |
| Wimberley | 50 min | Hill Country charm, weekend market |
| Dripping Springs | 35 min | Wineries, breweries, Salt Lick |

### 1-2 Hours
| Destination | Drive Time | Why Go |
|-------------|------------|--------|
| San Antonio | 80 min | Alamo, River Walk, Pearl District |
| Fredericksburg | 80 min | German heritage, wine country |
| Gruene | 60 min | Gruene Hall (oldest dance hall in Texas) |
| Enchanted Rock | 90 min | Iconic hike, reservations needed |

### Day Trip Tips
- **Rent a car** — Uber doesn't work outside Austin
- **Leave early** — Beat the heat (summer) or crowds (weekends)
- **Enchanted Rock requires reservations** — Book online 2+ weeks ahead
- **Wine country (290)** — Designate a driver or book a tour

---

## Common Mistakes

### Don't...
- **Schedule too much outdoors in summer** — Heat exhaustion is real
- **Underestimate distances** — Austin is sprawling
- **Skip breakfast tacos** — It's a cultural experience
- **Only go to Dirty 6th** — East 6th and Rainey are better
- **Drive I-35 at rush hour** — Plan around it
- **Assume everything is close** — Check distances before walking

### Do...
- **Bring a reusable water bottle** — Hydration is survival
- **Make BBQ reservations** — Or commit to the line experience
- **Check event calendars** — SXSW/ACL/F1 change everything
- **Talk to locals** — Austinites are friendly and proud of their city
- **Tip well** — Service industry is the backbone of Austin

---

## Useful Apps

| App | Purpose |
|-----|---------|
| Do512 | Event calendar, shows, festivals |
| Uber/Lyft | Getting around |
| Bird/Lime | Scooter rentals |
| CapMetro | Bus and rail (if needed) |
| Yelp | Restaurant discovery |
| Google Maps | Traffic, walking directions |

---

## Safety Notes

- **Austin is generally safe** — Use normal city awareness
- **6th Street late night** — Petty crime increases after midnight
- **Heat is the biggest danger** — Take it seriously in summer
- **Flash floods** — If it rains hard, don't cross flooded roads
- **Cedar Park, Round Rock, Pflugerville** — Suburbs are very safe
- **East Austin** — Most areas fine, some blocks still rough
