# Work Visas & Immigration — Austin

## Overview

Austin has strong demand for tech talent, making it a viable destination for work visas. However, US immigration is federal — Austin doesn't have special rules.

**Key point:** This is general information. Immigration law is complex. Consult an immigration attorney for your specific situation.

---

## Common Work Visas

### H-1B (Specialty Occupation)
**Most common tech work visa**

| Aspect | Details |
|--------|---------|
| Who qualifies | Bachelor's+ in specialty field |
| Duration | 3 years, renewable to 6 |
| Employer sponsored | Yes, required |
| Cap | 65,000 + 20,000 advanced degree |
| Lottery | Yes, typically April |
| Processing | 3-6 months (premium available) |

**Austin reality:**
- Major tech companies sponsor (Apple, Google, Meta, etc.)
- Startups sometimes sponsor (but less common)
- Lottery makes it uncertain
- Premium processing: ~$2,500 for faster

### L-1 (Intracompany Transfer)
**For employees of multinational companies**

| Aspect | Details |
|--------|---------|
| L-1A | Executives/managers (7 years max) |
| L-1B | Specialized knowledge (5 years max) |
| Requirement | 1 year at foreign office |
| Cap | No cap |
| Employer | Must have US and foreign offices |

**Austin reality:**
- Good option for international companies with Austin offices
- Oracle, Dell, IBM use this
- No lottery, more predictable

### O-1 (Extraordinary Ability)
**For individuals with extraordinary achievement**

| Aspect | Details |
|--------|---------|
| Who qualifies | Top of field (awards, publications, etc.) |
| Duration | Up to 3 years, renewable |
| Cap | No cap |
| Evidence | Extensive documentation required |

**Austin reality:**
- Founders, senior engineers with publications
- More flexible than H-1B
- Requires strong case preparation

### E-2 (Treaty Investor)
**For entrepreneurs from treaty countries**

| Aspect | Details |
|--------|---------|
| Who qualifies | Nationals of treaty countries |
| Investment | "Substantial" (typically $100K+) |
| Duration | 2-5 years, renewable indefinitely |
| Business | Must be active, not passive |

**Austin reality:**
- Popular with European entrepreneurs
- Good for starting business
- Doesn't lead directly to green card

### TN (USMCA - Canada/Mexico)
**For Canadian and Mexican professionals**

| Aspect | Details |
|--------|---------|
| Who qualifies | Specific professions listed |
| Duration | 3 years, renewable |
| Cap | No cap |
| Employer | Must have job offer |

**Austin reality:**
- Easier than H-1B
- Tech roles qualify
- Apply at border or consulate

---

## H-1B Sponsorship in Austin

### Companies That Sponsor
**Major tech (consistent sponsors):**
- Apple
- Google
- Meta
- Amazon
- Dell
- Oracle
- Indeed
- IBM

**Startups (variable):**
- Some well-funded startups sponsor
- Seed-stage rarely
- Ask directly in interviews

### How to Find Sponsors
- Filter job searches for "visa sponsorship"
- Ask recruiters directly
- Check H-1B databases (h1bdata.info)
- LinkedIn: research employee visas at target companies

### The Process
1. Get job offer
2. Employer files Labor Condition Application
3. Enter lottery (April)
4. If selected, file H-1B petition
5. Wait for approval
6. Start work October 1

### Cost to Employer
- $2,000-10,000+ in fees
- Attorney fees: $3,000-6,000
- Premium processing: ~$2,500 (optional)
- Some employers deduct from salary (controversial)

---

## Green Card Path

### Employment-Based Categories
| Category | Who | Timeline |
|----------|-----|----------|
| EB-1 | Extraordinary ability, executives | Fastest |
| EB-2 | Advanced degree or exceptional | 2-10+ years |
| EB-3 | Bachelor's or skilled workers | 2-10+ years |

### The Backlog Reality
- India, China: 10+ year waits for EB-2/EB-3
- Other countries: Much shorter
- Employer must sponsor PERM process
- Long, uncertain path

### Alternatives
- EB-1 if you qualify (no backlog)
- EB-5 investor visa ($800K+ investment)
- Marriage to US citizen
- Diversity lottery (limited countries)

---

## Student Pathway

### OPT (Optional Practical Training)
- After degree completion
- 12 months work authorization
- STEM: 24-month extension (3 years total)
- Good bridge to H-1B

### CPT (Curricular Practical Training)
- While studying
- Must be part of curriculum
- Internships, co-ops

### UT Austin
- Strong international student population
- OPT to H-1B pipeline established
- Many stay in Austin
- Career services help with visa employers

---

## Remote Work Complications

### If Working for US Company Abroad
- Generally not a visa issue (you're not in US)
- Tax implications complex
- Some companies don't allow

### If Visiting US on Visa
- B-1/B-2: Cannot work for US employer
- ESTA: Same restrictions
- Remote work for foreign employer: Gray area

### Digital Nomads
- No US "digital nomad" visa
- B-1/B-2 max 6 months
- Can't legally work for US company without work visa

---

## Spouse Work Authorization

### H-4 (H-1B Spouse)
- Can get EAD (work permit) if H-1B holder has approved I-140
- Takes months to obtain
- Renewable with H-4 status

### L-2 (L-1 Spouse)
- Automatically eligible for EAD
- Can work for any employer
- Good benefit of L-1

### O-3, E-2 Spouse
- Generally cannot work without own visa
- Can study

---

## Austin Immigration Resources

### Attorneys
- Many immigration attorneys in Austin
- Tech-focused firms understand industry
- Employer often covers legal fees

### Organizations
- **AILA Austin** — Attorney association
- **International Rescue Committee** — Refugee services
- **American Gateways** — Immigration legal services

### Community
- Large international community
- Many nationalities represented
- Cultural organizations active

---

## Practical Considerations

### Timing Your Move
- H-1B starts October 1 only
- Lottery in April
- Plan job search 6-12 months ahead
- Start early

### Negotiating
- Ask about visa sponsorship early
- Ask who covers fees
- Ask about green card sponsorship
- Get commitments in writing

### Backup Plans
- Apply to multiple companies
- Consider L-1 eligible companies
- Consider countries with easier paths
- Have contingency if lottery fails

### Living on a Visa
- Keep passport valid
- Maintain status carefully
- Document everything
- Travel carefully (re-entry risks)
- Consult attorney before changing jobs

---

## Reality Check

### Challenges
- H-1B lottery is uncertain (30% odds roughly)
- Green card backlog very long for some
- Immigration policy changes possible
- Employer dependence is stressful

### Advantages of Austin
- Strong tech job market
- Companies that sponsor
- Lower cost of living stretches salary
- Quality of life
- Growing international community

### Advice
- Start early
- Use immigration attorney
- Have backup plans
- Maintain status carefully
- Network with others on visas
