# Transportation — Austin

## The Reality

**Austin is a car city.** Unlike coastal metros, public transit is limited and sprawl is significant. Plan accordingly.

### Mode Share (Realistic)
| Mode | Usage |
|------|-------|
| Personal car | 75%+ |
| Rideshare | 15% |
| Bike/scooter | 5% |
| Public transit | 3% |
| Walking | 2% |

---

## Driving

### Car Necessity by Area
| Area | Car Needed? |
|------|-------------|
| Downtown | Optional (walkable + rideshare) |
| East Austin | Helpful but not essential |
| South Congress | Helpful |
| Zilker/Barton Hills | Yes |
| The Domain | Yes |
| Cedar Park/Round Rock | Absolutely |
| Westlake | Absolutely |

### Traffic Reality
- **I-35**: Nightmare. Austin's main artery, always congested.
- **Rush hours**: 7-9am, 4-7pm
- **Mopac (Loop 1)**: Better than I-35, still busy
- **183/290**: Variable, can surprise you
- **Weekends**: Downtown congested, suburbs fine

### I-35 Survival
- Avoid during rush hour if possible
- Use frontage roads for short distances
- Toll roads (183A, 130) bypass congestion
- Waze/Google Maps essential for real-time routing

### Parking
| Area | Difficulty | Cost |
|------|------------|------|
| Downtown | Hard | $15-30/day, $200-400/month |
| East Austin | Moderate | Street parking, some paid lots |
| SoCo | Moderate | Competitive, some paid |
| Domain | Easy | Free |
| Suburbs | Easy | Free everywhere |

### Toll Roads
- **130 Toll**: Eastern bypass around Austin
- **183A**: North Austin express
- **45 Toll**: Connects 183 to 130
- **MoPac Express Lanes**: Variable pricing

**Payment**: TxTag or pay-by-mail (higher rates)

---

## Public Transit (CapMetro)

### MetroRail (Red Line)
- **Route**: Downtown to Leander (north)
- **Stops**: Convention Center, Plaza Saltillo, Highland, Lakeline, etc.
- **Hours**: Limited (peak hours focus)
- **Frequency**: 15-30 min during peaks
- **Cost**: $1.25-3.50
- **Reality**: Commuter rail, not urban metro

### Bus System
- **Coverage**: Decent in central areas
- **Frequency**: 15-60 min depending on route
- **Key routes**:
  - Route 1: North-South (Lamar)
  - Route 7: East-West (Duval)
  - Route 20: Manor Road
  - MetroRapid 801/803: Faster service

### Fares
| Type | Cost |
|------|------|
| Single ride | $1.25 |
| Day pass | $2.50 |
| 7-day pass | $11.25 |
| 31-day pass | $41.25 |

### CapMetro App
- Trip planning
- Real-time arrivals
- Mobile tickets
- Essential if using transit

### Transit Reality
- Works for some commutes
- Not comprehensive
- Patience required
- Fine for occasional use
- Not practical for daily life in most areas

---

## Rideshare (Uber/Lyft)

### Availability
- **Excellent** throughout Austin
- 5-10 min pickup in most areas
- Both services operate normally

### Typical Fares
| Route | Cost |
|-------|------|
| Downtown to Airport | $25-40 |
| East Austin to Downtown | $10-18 |
| Domain to Downtown | $25-40 |
| Within Downtown | $8-15 |

### Surge Pricing
- Bar close (2am): Heavy surge
- SXSW: Extreme surge
- ACL: Heavy surge
- F1: Heavy surge
- Rain: Moderate surge

### Tips
- Schedule rides for airport
- Share rides to save money
- Check both apps for pricing
- Tip your driver

---

## Biking

### Infrastructure
- **Growing** but not comprehensive
- **Best areas**: Downtown, East Austin, UT campus
- **Butler Hike-and-Bike Trail**: 10-mile loop around Lady Bird Lake
- **Lance Armstrong Bikeway**: Downtown connector
- **Protected lanes**: Increasing but gaps exist

### Bike Share (MetroBike)
- Docked bikes around central Austin
- $1 to unlock + $0.17/minute
- Electric and regular bikes
- Good for short trips

### Reality Check
- Hot summers make biking brutal
- Some routes feel unsafe
- Drivers not always bike-aware
- Great for recreation, challenging for commuting
- Flat terrain helps (unlike SF hills)

### E-Bikes
- Growing popularity
- Beat the heat with less effort
- Good for commuters in central areas
- Can use bike lanes

---

## Scooters

### Available Brands
- Bird
- Lime
- Lyft Scooters
- Others rotate

### How They Work
1. Download app
2. Find nearby scooter (GPS)
3. Scan to unlock
4. Ride
5. Park responsibly

### Cost
- Unlock: $1
- Per minute: $0.25-0.40
- 10-min ride: ~$4-5

### Rules
- Ride in bike lanes or streets (not sidewalks in some areas)
- Helmet recommended (not required for 18+)
- Park upright, not blocking pedestrians
- No riding on 6th Street at night

### Best Use Cases
- Last mile from transit
- Short downtown trips
- Bar hopping (one drink max)
- When parking is nightmare

---

## Airport (AUS)

### Austin-Bergstrom International Airport
- **Location**: Southeast Austin (20-30 min from downtown)
- **Code**: AUS
- **Size**: Medium hub, growing fast

### Getting To/From

| Mode | Cost | Time |
|------|------|------|
| Rideshare | $25-40 | 20-30 min |
| Bus (Route 20) | $1.25 | 40-60 min |
| Rental car | Varies | 20-30 min |
| Taxi | $30-50 | 20-30 min |

### Airport Tips
- Arrive 2 hours before domestic
- TSA PreCheck worth it (common lines)
- Food options inside decent
- Cell phone lot available

### Airlines
- Southwest hub (major presence)
- American, Delta, United
- Some international (limited)

---

## Day Trip Transportation

### To San Antonio (80 miles)
- **Drive**: 1.5 hours
- **Bus**: Greyhound, FlixBus (~2 hours)
- **No train**: Sadly

### To Houston (165 miles)
- **Drive**: 2.5-3 hours
- **Bus**: Greyhound, various (~3 hours)
- **No train**: Still no

### To Dallas (195 miles)
- **Drive**: 3-3.5 hours
- **Bus**: Greyhound, Vonlane (luxury), FlixBus
- **No train**: Proposed but not built

### Hill Country
- **Car only**: No transit to Fredericksburg, wineries, etc.
- **Day tours**: Available from Austin

---

## Getting Around Without a Car

### Feasible In
- Downtown (walking + rideshare)
- East Austin (bike + rideshare)
- UT Campus (walking + bus)
- South Congress (walking + rideshare)
- The Domain (walking within)

### Challenging But Possible
- Mueller (bike-friendly)
- South Lamar (rideshare dependent)
- Hyde Park (transit exists)

### Car Required
- Cedar Park, Round Rock
- Westlake, Bee Cave
- Most suburbs
- Hill Country trips
- South Austin (most areas)

---

## Cost Comparison

### Monthly Transportation Costs

| Mode | Monthly Cost |
|------|--------------|
| Own car (with parking) | $400-800 |
| Own car (no parking cost) | $300-500 |
| Rideshare only | $300-600 |
| Transit + occasional rideshare | $100-200 |
| Bike + rideshare | $100-250 |

### Break-Even Analysis
If living downtown without parking costs:
- Rideshare < $500/month: Skip car ownership
- Beyond that: Consider car

---

## Future Transit

### Project Connect
- Voter-approved transit expansion
- New light rail lines planned
- Orange Line: North-South
- Blue Line: East-West
- **Timeline**: Under construction, years away
- **Reality**: Transformative if completed

### What's Coming
- MetroRapid expansions
- More bike infrastructure
- Transit-oriented development
- Still a car city for now
