# Startups & VC — Austin

## Startup Ecosystem

Austin has emerged as a top-tier startup hub, ranking 8th in the US. The tech migration accelerated an already growing ecosystem.

### Austin vs Other Hubs
| Factor | Austin | SF | NYC |
|--------|--------|-----|-----|
| VC availability | Growing | Highest | High |
| Talent pool | Strong | Deepest | Deep |
| Cost of living | Moderate | Very High | Very High |
| Quality of life | High | Good | Good |
| Network density | Medium | Highest | High |

---

## Funding Landscape

### VC Presence
**Local Firms:**
- Silverton Partners
- LiveOak Venture Partners
- S3 Ventures
- Next Coast Ventures
- Tritium Partners
- ATX Venture Partners

**National Firms with Austin Focus:**
- Andreessen Horowitz (a16z)
- Sequoia
- Accel
- Many SF/NYC firms investing in Austin

### Funding by Stage
| Stage | Typical Range | Austin Activity |
|-------|---------------|-----------------|
| Pre-seed | $250K-1M | Active, angels + micro VCs |
| Seed | $1M-4M | Strong, many options |
| Series A | $5M-15M | Growing rapidly |
| Series B+ | $15M+ | Improving, often outside capital |

### Angel Community
- Active angel investor scene
- Austin Angels
- Central Texas Angel Network (CTAN)
- Individual tech executives invest

---

## Ecosystem Players

### Capital Factory
**Austin's startup hub**

- **What**: Coworking, accelerator, community
- **Where**: Downtown Austin
- **Why join**: Network, events, mentorship, funding connections
- **Cost**: Membership required for full access
- **Notable**: Hosts SXSW events, major hub

### Accelerators
| Program | Focus | Investment |
|---------|-------|------------|
| Techstars Austin | Tech broadly | $120K |
| SKU | Consumer products | Varies |
| MassChallenge Texas | Various | Non-dilutive |
| Austin Technology Incubator (ATI) | University-connected | Varies |

### Organizations
- **Austin Technology Council** — Industry group
- **Built In Austin** — Jobs, events, community
- **Austin Startup Week** — Annual event
- **SXSW Interactive** — Major annual gathering

---

## Starting Up in Austin

### Advantages
- Lower burn rate than coastal cities
- Talent available (and relocating)
- No state income tax
- Quality of life aids recruiting
- Growing network effects
- Less competition for attention than SF

### Challenges
- Smaller VC pool (but growing)
- Less late-stage capital locally
- Shallower talent pool for specialized roles
- May need to fundraise in SF/NYC anyway
- Network still developing vs established hubs

### Typical Path
1. Incorporate (Delaware C-corp typical for VC)
2. Join community (Capital Factory, coworking)
3. Build product
4. Raise from angels/local seed funds
5. Series A+ may involve coastal VCs
6. Scale locally or open SF/NYC offices

---

## Notable Austin Startups

### Unicorns (Historical)
- **Dell** — The OG Austin tech success
- **Vrbo** (HomeAway) — Vacation rentals, acquired by Expedia
- **RetailMeNot** — Coupons, went public
- **Bumble** — Dating app, went public
- **SolarWinds** — IT management, went public

### Recent Success Stories
- **Talkdesk** — Cloud contact center
- **Procore** — Construction software
- **BigCommerce** — E-commerce
- **Various crypto** — Several projects

### Acquired
- Many successful exits via M&A
- Google, Facebook, Amazon have acquired Austin startups

---

## Funding Process

### Getting Meetings
- Warm intros matter most
- Capital Factory network helps
- SXSW is fundraising opportunity
- LinkedIn InMail works sometimes
- Cold email can work with good deck

### What Investors Look For
- Strong team
- Large market
- Traction or compelling vision
- Why Austin (can be advantage)
- Defensibility

### Austin-Specific Tips
- "We're in Austin" is now a plus (cost efficiency)
- Lifestyle angle helps recruiting pitch
- Local VCs want to build local ecosystem
- National VCs have Austin partners/scouts

---

## Talent & Hiring

### Finding Talent
- UT Austin pipeline (strong)
- Tech company alumni (Apple, Google, etc.)
- Relocators (many moving from coastal cities)
- Remote workers in Austin
- Capital Factory network

### Competing for Talent
- Big tech salaries are competition
- Equity story must be compelling
- Culture and mission matter
- Work-life balance valued
- Stock options expected

### Remote Hiring
- Many startups hire remote
- Can access national talent
- Austin HQ + distributed team common

---

## Support Services

### Legal
- Wilson Sonsini — Tech-focused, major firm
- DLA Piper — International
- Cooley — Startup specialists
- Local boutique firms

### Accounting
- Tech-focused CPAs available
- Many serve startups specifically
- R&D tax credits important

### Banking
- Silicon Valley Bank
- Mercury — Startup-focused
- Brex — Corporate cards
- Traditional banks work too

### HR/PEO
- Gusto — Popular with startups
- Justworks — PEO option
- TriNet — Larger PEO

---

## Events & Networking

### Major Events
| Event | When | Focus |
|-------|------|-------|
| SXSW Interactive | March | Tech, culture, networking |
| Austin Startup Week | November | Local ecosystem |
| Capital Factory events | Ongoing | Various |
| Techstars Demo Day | Varies | Batch graduates |

### Regular Meetups
- Check Meetup.com
- Language/framework specific
- Industry specific
- Founder-focused

### Informal Networking
- Coffee meetings are culture
- Outdoor activities (runs, hikes) with founders
- Happy hours
- UT football tailgates (if you're into it)

---

## Cost Comparison

### Monthly Burn (5-Person Startup)
| Item | Austin | SF |
|------|--------|-----|
| Office (coworking) | $2,000 | $4,000 |
| Salaries (eng-heavy) | $60,000 | $80,000 |
| Benefits | $3,000 | $4,000 |
| Other | $5,000 | $7,000 |
| **Total** | **$70,000** | **$95,000** |

### Runway Advantage
- Same raise goes 25-40% further
- Compelling pitch to investors
- More time to find product-market fit

---

## Advice for Austin Founders

### Do
- Join Capital Factory or similar community
- Network actively (Austin is friendly)
- Leverage UT Austin for talent
- Attend SXSW (at least for networking)
- Consider lifestyle as recruiting advantage
- Build local relationships with VCs

### Don't
- Assume Austin VCs are only option
- Neglect coastal VC relationships
- Think smaller because you're not in SF
- Ignore the ecosystem events
- Underestimate the heat (seriously, office AC matters)

### Mindset
- Austin is now major league
- Act like a startup in any top hub
- Use cost advantage strategically
- Build for scale, not just local
