# Safety & Laws — Austin

## General Safety

### Crime Overview
- **Violent crime**: Below national average
- **Property crime**: Average for cities this size
- **Overall**: Safe by US city standards

### By Area
| Area | Safety Level |
|------|--------------|
| Downtown (daytime) | Safe |
| Downtown (late night) | Moderate caution |
| 6th Street (late night) | Heightened awareness |
| East Austin | Varies by block |
| Suburbs | Very safe |
| South Austin | Safe |
| North Austin | Safe |

### Common Issues
- **Vehicle break-ins**: Don't leave valuables visible
- **Bike theft**: Lock well, register with APD
- **Package theft**: Common in apartments
- **Scooter accidents**: Wear helmet, stay alert

---

## 6th Street Safety

### Late Night (After Midnight)
- Fights can break out
- Petty theft increases
- Aggressive panhandling
- Drunk driving a major issue

### Safety Tips
- Stay with your group
- Watch your drink
- Use rideshare (don't drink and drive)
- Avoid confrontations
- Keep phone/wallet secure

### East 6th vs Dirty 6th
- **Dirty 6th (West)**: More chaotic, younger crowd
- **East 6th**: Generally calmer, hipper
- **Rainey Street**: Most upscale, safest

---

## Weather Dangers

### Heat (Highest Risk)

**Summer temperatures reach 100-110F (38-43C)**

| Condition | Signs | Action |
|-----------|-------|--------|
| Heat exhaustion | Heavy sweating, weakness, nausea | Move to AC, hydrate |
| Heat stroke | No sweating, confusion, hot skin | Call 911 immediately |

**Prevention:**
- Hydrate constantly
- Avoid outdoor activity 11am-4pm
- Never leave pets/kids in cars
- Take heat seriously

### Flash Floods

**Austin is in "Flash Flood Alley"**

- Floods develop rapidly
- Low water crossings are deadly
- "Turn around, don't drown"
- 6+ inches of water can sweep cars away

**What to do:**
- Never drive through flooded roads
- Check weather before outdoor activities
- Download weather app with alerts

### Severe Weather

- **Tornadoes**: Possible, especially spring
- **Hail**: Can be severe
- **Lightning**: Summer thunderstorms

**Resources:**
- Weather alerts (phone)
- NOAA weather radio
- Local news during storms

---

## Texas Gun Laws

### Key Points
- **Open carry**: Legal (21+, no permit required since 2021)
- **Concealed carry**: Legal (21+, no permit required)
- **In vehicles**: Guns legal in personal vehicles
- **Businesses**: Can prohibit with 30.06/30.07 signs
- **Bars**: Generally prohibited

### For Visitors
- Expect to see guns
- Many Texans legally carry
- Don't touch or handle others' firearms
- If uncomfortable, check for 30.06/30.07 signs (prohibition)

### What Signs Mean
- **30.06**: No concealed carry allowed
- **30.07**: No open carry allowed
- **51%**: Bars deriving 51%+ revenue from alcohol (no guns)

---

## Drug Laws

### Cannabis
- **Illegal** in Texas
- **Not decriminalized** (unlike many states)
- Possession can result in arrest
- CBD with <0.3% THC is legal
- Don't assume Austin is lenient

### Other Drugs
- Standard federal classifications
- Possession is prosecuted
- No safe injection sites
- Fentanyl crisis affecting area

### Alcohol
- **Legal age**: 21
- **Bars close**: 2am
- **Package store**: Beer/wine at grocery, liquor at liquor stores
- **Sunday sales**: Restricted hours historically (now relaxed)
- **Public drinking**: Illegal (except designated areas)

---

## Driving Laws

### Key Rules
- **Speed limits**: Enforced, especially school zones
- **School zones**: 20 mph when lights flashing
- **Phone use**: Texting while driving illegal
- **DUI/DWI**: Aggressively prosecuted
- **Seat belts**: Required
- **Move over law**: Slow down/move over for emergency vehicles

### DWI Penalties
| Offense | Consequence |
|---------|-------------|
| First | Up to 180 days jail, $2,000 fine |
| Second | Up to 1 year jail, $4,000 fine |
| Third | 2-10 years prison, $10,000 fine |

**Zero tolerance** for under 21 with any alcohol

### Traffic Enforcement
- Austin PD present but not aggressive
- Highway patrol on I-35, 183
- Red light cameras: No
- Speed cameras: No

---

## Emergency Services

### Numbers
- **Emergency**: 911
- **Non-emergency APD**: 311
- **Poison Control**: 1-800-222-1222

### Hospitals
| Hospital | Location | Notes |
|----------|----------|-------|
| Dell Seton Medical Center | Downtown | Major trauma center |
| St. David's | Multiple locations | Large network |
| Ascension Seton | Multiple | Catholic network |
| Dell Children's | Central | Pediatric |

### Urgent Care
- Multiple locations around city
- Wait times vary
- Cost: $100-300 without insurance
- Good for non-emergencies

---

## Homelessness

### Current Situation
- Visible homeless population
- Concentrated downtown, under overpasses
- Encampments in some areas
- City policy has shifted over years

### For Residents/Visitors
- Generally not dangerous
- May be asked for money
- Decline politely if preferred
- Don't leave valuables visible
- Report aggressive behavior to 311

### Resources to Help
- Mobile Loaves & Fishes
- Austin Resource Center for the Homeless (ARCH)
- Front Steps
- Caritas of Austin

---

## Tenant Rights

### Texas is Landlord-Friendly
- No rent control
- Leases are generally binding
- Security deposit return within 30 days
- 24-hour notice required for entry (with exceptions)
- Eviction process relatively quick

### Know Your Rights
- Repairs must be made in "reasonable time"
- Document everything in writing
- Texas Tenants' Union provides resources
- Small claims court for disputes

### Red Flags
- Deposits exceeding one month rent (not illegal but caution)
- Refusing to document condition at move-in
- No written lease (get everything in writing)

---

## Employment Laws

### At-Will State
- Employment can be terminated for any legal reason
- No required notice period
- Non-competes are enforceable (with limits)

### Minimum Wage
- Federal minimum ($7.25) — no state minimum higher
- Most jobs pay above this
- No paid sick leave mandate (city tried, blocked)

### Workers' Compensation
- Required for most employers
- File claims promptly
- Can't be fired for filing

---

## Discrimination Protections

### Protected Classes
- **Federal**: Race, color, religion, sex, national origin, age, disability
- **Texas**: Same as federal
- **Austin**: Adds LGBTQ+ protections

### Reporting
- Equal Employment Opportunity Commission (EEOC)
- Texas Workforce Commission Civil Rights Division
- Austin Human Rights Commission

---

## Scams to Avoid

### Common Austin Scams
- **Rental scams**: Never wire money before seeing apartment
- **Car buying**: Private sales, meet at police station
- **Ticket scams**: Buy from official sources only
- **Event parking**: Unlicensed lots may not be secure

### Red Flags
- Too-good-to-be-true prices
- Urgency to send money
- Cash only, no documentation
- Meeting in isolated areas
