# Moving & Settling — Austin

## Before You Move

### Research Phase
1. **Visit first** — Spend a week, experience the heat (summer) or cedar (winter)
2. **Choose neighborhood** — See `neighborhoods-choosing.md`
3. **Estimate budget** — Austin is expensive now
4. **Job first** — Ideally have job secured before moving
5. **Plan timeline** — Give yourself 4-6 weeks for the transition

### Remote Move
If unable to visit first:
- Virtual apartment tours available
- Research neighborhoods thoroughly
- Consider short-term rental first
- Join Austin subreddits and Facebook groups

---

## Finding Housing

### Timeline
- Start searching 4-6 weeks before move
- Popular apartments go fast
- Have documents ready

### Documents Needed
- Proof of income (paystubs, offer letter)
- ID/driver's license
- SSN
- Bank statements (sometimes)
- References (sometimes)

### Where to Search
| Source | Type |
|--------|------|
| Apartments.com | Apartments |
| Zillow | All types |
| Trulia | All types |
| Craigslist | All types (be careful) |
| Facebook Marketplace | Rooms, sublets |
| ApartmentFinder | Apartments |

### What to Expect
| Unit Type | Central | Suburbs |
|-----------|---------|---------|
| Studio | $1,400-1,800 | $1,100-1,400 |
| 1BR | $1,800-2,500 | $1,300-1,800 |
| 2BR | $2,500-3,500 | $1,800-2,400 |

### Fees
- Application fee: $50-100
- Admin fee: $100-300
- Security deposit: 1 month typically
- Pet deposit: $200-500
- Pet rent: $25-50/month

### Red Flags
- Too-good-to-be-true prices
- Urgency to send money
- Can't see unit in person
- No lease agreement

---

## First Week Checklist

### Day 1-2: Basics
- [ ] Utilities on (should be scheduled ahead)
- [ ] Internet setup
- [ ] Unpack essentials
- [ ] Grocery run (find nearest HEB)
- [ ] Learn neighborhood

### Day 3-7: Administrative
- [ ] Texas driver's license (make DPS appointment)
- [ ] Vehicle registration (if applicable)
- [ ] Update address everywhere
- [ ] Bank account (if switching)
- [ ] Find primary care doctor

### Week 2+: Settling
- [ ] Explore neighborhoods
- [ ] Find your breakfast taco spot
- [ ] Establish routines (gym, coffee shop)
- [ ] Meet neighbors
- [ ] Join activities/groups

---

## Setting Up Utilities

### Electricity (Austin Energy)
- **Setup**: austinenergy.com or 311
- **Deposit**: May be required
- **Timeline**: Can schedule before move-in
- **Average**: $100-200/month (higher summer)

### Gas (Texas Gas Service)
- **Setup**: texasgasservice.com
- **Timeline**: Schedule ahead
- **Average**: $30-60/month

### Water (Austin Water)
- **Setup**: austintexas.gov/water
- **Note**: Often bundled with trash
- **Average**: $50-100/month

### Internet
- **Options**: AT&T, Google Fiber, Spectrum, Grande
- **Check**: Availability at your address
- **Timeline**: Schedule install before move
- **Average**: $50-80/month

---

## Essential Services

### Healthcare
- Find primary care doctor (use insurance network)
- Know nearest urgent care
- Know nearest ER
- Transfer medical records

### Banking
If keeping current bank:
- Update address
- May want local branch anyway

If switching:
- Chase, BoA widespread
- Frost Bank (Texas regional)
- Credit unions often better rates

### Postal
- Change of address: usps.com
- Forward mail (usually 6 months)
- Update important accounts

---

## Getting Around Initially

### Without a Car
- Rideshare for first days
- Explore bikeshare/scooter
- Figure out transit options
- Consider if you can stay car-free

### With a Car
- Registration/inspection needed within 30 days
- Learn your commute route
- Download Waze
- Get TxTag for toll roads

### Priority Areas to Learn
- Grocery store (HEB)
- Pharmacy
- Route to work
- Urgent care
- Gas stations

---

## Cost of Living Adjustment

### Coming from Bay Area
- Housing 40-50% cheaper
- No state income tax (save 10-13%)
- Food similar or slightly cheaper
- Car likely more necessary
- Overall: Significant savings

### Coming from Midwest/South
- Housing likely more expensive
- Food similar
- Lifestyle costs (outdoor activities) similar
- Overall: May be cost increase

### Unexpected Costs
- Property taxes (high) — affects rent indirectly
- Car expenses (if didn't have one)
- AC electricity (summer)
- Healthcare (if changing plans)

---

## Making Friends

### Challenge
Austin is transient — many people move here, relationships take effort.

### Strategies
- **Activity-based**: Running groups, climbing gyms, sports leagues
- **Meetup.com**: Groups for everything
- **Work**: Colleagues are natural connections
- **Neighborhood**: Be friendly, say hello
- **Bars/coffee shops**: Regulars become friends

### Social Groups
- Austin Sports & Social Club (leagues)
- November Project (free outdoor fitness)
- Reddit meetups (r/Austin)
- Bumble BFF
- Industry-specific groups

### Timeline
Expect 6-12 months to build solid friend group. Be patient, keep trying.

---

## Work-Life Setup

### Remote Work
- Coffee shops plentiful
- Co-working options (Capital Factory, WeWork, others)
- Home office setup
- Internet reliability important

### Commuting
- Know your route before first day
- Account for traffic (I-35 especially)
- Consider location relative to office
- Remote hybrid gives flexibility

### Work Culture
- Generally casual
- Outdoor lunch meetings common
- Happy hour culture
- Work-life balance better than coastal cities

---

## Austin Survival Tips

### Summer Heat
- Take it seriously
- Hydrate constantly
- Indoor activities 11am-6pm
- AC in home and car essential
- Early morning for outdoor exercise

### Allergies
- Cedar fever (Dec-Feb) is real
- Get tested, get meds
- Air purifier helps
- Many locals affected

### Traffic
- I-35 is nightmare, plan around it
- Rush hours: 7-9am, 4-7pm
- Waze/Google Maps essential
- Leave early, always

### Culture
- "Y'all" is vocabulary
- Be friendly, people talk to strangers
- Support local businesses
- Embrace breakfast tacos
- Don't bash Texas

---

## 30/60/90 Day Milestones

### 30 Days
- [ ] License and registration done
- [ ] Utilities and internet stable
- [ ] Know your neighborhood
- [ ] Healthcare established
- [ ] Basic routine set

### 60 Days
- [ ] Found regular spots (coffee, food, gym)
- [ ] Some social connections forming
- [ ] Work rhythm established
- [ ] Explored multiple neighborhoods
- [ ] Feel oriented

### 90 Days
- [ ] Friend group developing
- [ ] Feel like you live here (not visiting)
- [ ] Know traffic patterns
- [ ] Favorite spots established
- [ ] Consider yourself Austinite

---

## Long-Term Considerations

### When to Buy
- Know the city first (rent 1-2 years)
- Understand neighborhoods
- Market still competitive
- Property taxes are HIGH
- Consider lifestyle flexibility vs. ownership

### Career Growth
- Network actively
- Austin tech community connected
- SXSW Interactive for exposure
- Local meetups for industry

### Community Involvement
- Volunteer opportunities (many)
- Local politics active
- Neighborhood associations
- Support causes you care about

### Stay vs. Go
- Many stay for lifestyle
- Some outgrow (want bigger city)
- Career opportunities growing
- Heat is real consideration
- Give it 2+ years before deciding
