# South Austin Neighborhoods

## Zilker

### Overview
- **Vibe**: Outdoor lifestyle, parks, family-friendly
- **Rent 1BR**: $2,200-3,200/month (limited inventory)
- **Walk Score**: 50-65

### Who Lives Here
- Outdoors enthusiasts
- Young families
- Tech workers who prioritize lifestyle
- Longtime Austin residents who bought early

### Pros
- Zilker Park at your doorstep
- Barton Springs Pool nearby
- Lady Bird Lake access
- Excellent trail running/biking
- Close to Downtown (10 min)
- ACL Festival in your backyard

### Cons
- Very expensive (premium for location)
- Limited rental inventory (mostly homes)
- Traffic during events (ACL, Trail of Lights)
- Flooding risk in some areas
- Older housing stock

### Key Spots
- Zilker Park (obvious)
- Barton Springs Pool
- Butler Hike-and-Bike Trail
- Shady Grove (RIP but the vibe lives on)

### Best For
Outdoor enthusiasts who can afford the premium. Ideal if you kayak, run, or bike daily.

---

## Barton Hills

### Overview
- **Vibe**: Nature retreat in the city
- **Rent 1BR**: $1,800-2,800/month
- **Walk Score**: 45

### Who Lives Here
- Outdoors-oriented professionals
- Families with older children
- UT faculty
- Environmental advocates

### Pros
- Barton Creek Greenbelt access
- Swimming holes (Campbell's Hole, Twin Falls)
- Quiet, tree-covered streets
- Strong community feel
- Close to Zilker

### Cons
- Car required
- Limited commercial amenities
- Older homes, some need work
- Flooding concerns
- Far from North Austin employers

### Key Spots
- Barton Creek Greenbelt
- Barton Springs Pool
- Deep Eddy Pool
- South Lamar restaurants nearby

### Best For
Nature lovers who want to live adjacent to the greenbelt. Great for trail running and swimming.

---

## Bouldin Creek

### Overview
- **Vibe**: Quirky, established, old Austin
- **Rent 1BR**: $1,800-2,600/month
- **Walk Score**: 65-75

### Who Lives Here
- Artists and musicians
- Long-time Austin residents
- Young professionals seeking character
- Creative industry workers

### Pros
- Walking distance to South Congress
- Distinctive homes (yard art, murals)
- Strong neighborhood identity
- Local coffee shops and restaurants
- Close to Lady Bird Lake

### Cons
- Getting expensive quickly
- Limited new rental inventory
- Can be quirky to a fault
- Street parking only
- Some areas flood

### Key Spots
- Bouldin Creek Cafe (vegetarian institution)
- Radio Coffee & Beer
- Elizabeth Street Cafe
- South First Street food trucks

### Best For
Those seeking authentic old Austin character. Artists, musicians, creative types.

---

## South Lamar

### Overview
- **Vibe**: Entertainment corridor, diverse dining
- **Rent 1BR**: $1,600-2,400/month
- **Walk Score**: 60-70

### Who Lives Here
- Young professionals
- Restaurant/service industry workers
- Entertainment industry
- Relocators from other cities

### Pros
- Restaurant and bar density
- Alamo Drafthouse (original location)
- Walkable to some things
- Mid-range pricing for central location
- Easy access to Zilker, Barton Springs

### Cons
- Traffic heavy on Lamar
- Strip mall aesthetic in places
- Can be loud (entertainment venues)
- Pedestrian safety concerns
- Gentrifying quickly

### Key Spots
- Alamo Drafthouse
- Uchi (legendary sushi)
- Matt's El Rancho (Tex-Mex institution)
- Saxon Pub (songwriters)

### Best For
Entertainment lovers who want to be close to nightlife without Downtown prices.

---

## Travis Heights

### Overview
- **Vibe**: Established, close to SoCo, family-oriented
- **Rent 1BR**: $1,800-2,800/month
- **Walk Score**: 65-75

### Who Lives Here
- Young families
- Professionals who want walkability
- Long-time Austin residents
- People priced out of Zilker

### Pros
- Walking distance to South Congress
- Excellent elementary school (Travis Heights)
- Hike-and-bike trail access
- Established trees, character homes
- Community feel

### Cons
- Expensive for what you get
- Limited new construction
- Parking competitive
- Some streets flood
- Far from North Austin

### Best For
Families who want central Austin and good schools. Couples planning to have kids.

---

## Circle C

### Overview
- **Vibe**: Master-planned suburban, family paradise
- **Rent 1BR**: $1,500-2,200/month
- **Homes**: $500,000-800,000+

### Who Lives Here
- Families with school-age children
- People who commute to Downtown
- Those who want space and safety
- Former Californians seeking suburban life

### Pros
- Excellent schools (AISD)
- Community pools, parks, trails
- Very safe
- New construction available
- Community events

### Cons
- 20-30 min to Downtown
- Car required for everything
- Suburban (not "Austin weird")
- HOA rules
- Limited nightlife/entertainment

### Key Spots
- Lady Bird Johnson Wildflower Center
- Veloway (bike trail)
- Circle C Metro Park
- HEB (suburb lifeblood)

### Best For
Families who prioritize schools and safety over urban character. Commuters willing to drive.

---

## South Austin Summary

| Area | Character | Price | Best For |
|------|-----------|-------|----------|
| Zilker | Outdoor lifestyle | $$$ | Nature lovers, no kids |
| Barton Hills | Greenbelt access | $$ | Trail runners, swimmers |
| Bouldin Creek | Quirky, artistic | $$ | Creative types |
| South Lamar | Entertainment | $$ | Nightlife, dining |
| Travis Heights | Family, walkable | $$$ | Young families |
| Circle C | Suburban, schools | $$ | Families, commuters |
