# Venue Guide by Genre — Austin

## Quick Reference

| Genre | Top Venues |
|-------|------------|
| Country/Honky Tonk | White Horse, Broken Spoke, Sagebrush |
| Rock/Indie | Mohawk, Stubb's, Hotel Vegas |
| Blues/Soul | Antone's, C-Boy's Heart & Soul |
| Singer-Songwriter | Saxon Pub, Cactus Cafe |
| Jazz | Elephant Room, Parker Jazz Club |
| Electronic/DJ | Kingdom, Lanai, Plush |
| Punk/Metal | Mohawk, Lost Well, Hotel Vegas |
| Latin | Sahara Lounge, various |
| Classical | Bass Concert Hall, Long Center |

---

## By Venue Size

### Large (2,000+)
| Venue | Capacity | Typical Acts |
|-------|----------|--------------|
| Moody Center | 15,000 | Arena tours |
| Germania Amphitheater | 14,000 | Summer tours |
| ACL Live | 2,750 | Major acts |
| Bass Concert Hall | 3,000 | Classical, Broadway |
| Long Center | 2,300 | Orchestra, dance |
| Stubb's Amphitheater | 2,500 | Rock, indie |

### Medium (500-2,000)
| Venue | Capacity | Typical Acts |
|-------|----------|--------------|
| Emo's | 1,900 | Rock, punk |
| Stubb's Indoor | 1,300 | Rock, indie |
| Mohawk | 1,200 | Indie, punk |
| Paramount Theatre | 1,200 | Film, music, comedy |
| Scoot Inn | 1,000 | Rock, folk |
| Empire Control Room | 500 | Indie, electronic |

### Small (<500)
| Venue | Capacity | Typical Acts |
|-------|----------|--------------|
| Continental Club | 200 | Blues, country |
| Saxon Pub | 200 | Songwriters |
| Cactus Cafe | 150 | Folk, acoustic |
| Elephant Room | 100 | Jazz |
| Antone's | 300 | Blues |
| Parish | 350 | Indie, DJ |
| White Horse | 250 | Country |

---

## Venue Deep Dives

### Continental Club
- **Location**: South Congress
- **Genre**: Blues, rock, country
- **Vibe**: Historic (1955), Austin institution
- **Cover**: $5-15 (often free early show)
- **What to know**: Two shows nightly, early show often free
- **Celebrity sightings**: Musicians hang here

### Mohawk
- **Location**: Red River Cultural District
- **Genre**: Indie, rock, punk
- **Vibe**: Indoor/outdoor, young crowd
- **Cover**: $10-30
- **What to know**: Indoor and outdoor stages, balcony seating
- **Bar**: Good beer selection

### Stubb's Bar-B-Q
- **Location**: Red River
- **Genre**: Everything (booking-dependent)
- **Vibe**: BBQ restaurant + music venue
- **Cover**: $20-60
- **What to know**: Indoor for smaller acts, amphitheater for larger
- **Food**: Yes, BBQ available

### Antone's
- **Location**: Downtown (5th Street)
- **Genre**: Blues, soul
- **Vibe**: Historic blues club (since 1975)
- **Cover**: $15-50
- **History**: Stevie Ray Vaughan, Muddy Waters, B.B. King played here
- **What to know**: Relocated multiple times, spirit remains

### Saxon Pub
- **Location**: South Lamar
- **Genre**: Texas songwriters, country, americana
- **Vibe**: Listening room, respect the music
- **Cover**: $5-15
- **What to know**: No talking during songs (enforced)
- **Who plays**: Legendary Texas songwriters

### White Horse
- **Location**: East Austin
- **Genre**: Honky tonk, country, western swing
- **Vibe**: Dancing, boots, beer
- **Cover**: Free-$10
- **What to know**: Dance floor active, two-stepping happens
- **Pool tables**: Yes

### Elephant Room
- **Location**: Downtown (basement)
- **Genre**: Jazz only
- **Vibe**: Dark, intimate, serious jazz
- **Cover**: $5-15
- **What to know**: Basement venue, gets crowded, come early for seats
- **Shows**: Nightly

### ACL Live at The Moody Theater
- **Location**: Downtown (2nd Street)
- **Genre**: Major touring acts
- **Vibe**: Beautiful venue, great sound
- **Cover**: $40-150+
- **What to know**: Home of ACL TV show tapings (free lottery)
- **Seating**: Mix of standing and seated

### Hotel Vegas
- **Location**: East Austin
- **Genre**: Garage rock, punk, indie
- **Vibe**: Dive bar meets serious music
- **Cover**: $5-15
- **What to know**: Two stages, pool table, patio
- **Adjacent**: Volstead Lounge (craft cocktails)

### Broken Spoke
- **Location**: South Lamar
- **Genre**: Traditional Texas country
- **Vibe**: Historic dance hall (1964)
- **Cover**: $5-15
- **What to know**: Real deal Texas honky tonk, tourist-friendly but authentic
- **Dancing**: Yes, country dancing

---

## By Neighborhood

### Red River Cultural District
**The cluster of venues fighting development pressure**
- Mohawk
- Stubb's
- Cheer Up Charlie's
- Elysium
- Barbarella
- Valhalla

### East Austin
- Hotel Vegas / Volstead
- White Horse
- Sagebrush
- Sahara Lounge
- Hotel Vegas

### South Congress / South Lamar
- Continental Club
- C-Boy's Heart & Soul
- Saxon Pub
- Broken Spoke

### Downtown
- Antone's
- Elephant Room
- Parish
- ACL Live
- Paramount Theatre

---

## Free/Cheap Music

### Always Free (with drink purchase)
- Many bars on 6th Street
- Hotel Vegas (some shows)
- White Horse (some nights)
- Sagebrush
- Various restaurant patios

### Usually Under $15
- Saxon Pub
- Continental Club (early shows)
- C-Boy's Heart & Soul
- Elephant Room
- Cactus Cafe

### Worth the Price
- Stubbs (outdoor shows)
- Mohawk (quality lineups)
- ACL Live (sound quality)
- Antone's (historical significance)

---

## Venue Rules & Tips

### Common Rules
- **21+ most venues** (some 18+ shows exist)
- **ID required** even if obviously over 21
- **Re-entry**: Not always allowed, ask first
- **Smoking**: Outside only
- **Photos/video**: Usually fine, no flash

### Tips
- **Arrive early** for small venues (no reserved seating)
- **Cash for tips** for bar/band
- **Earplugs** — venues are LOUD
- **Check social media** for last-minute changes
- **Buy merch** from bands (they need the money)

### Ticketing
- Most through venue websites
- Prekindle for many Austin shows
- Ticketmaster/AXS for large venues
- At-door usually possible for smaller venues

---

## Outdoor Venues

### Stubb's Amphitheater
- Great for summer shows
- BBQ available
- Standing room

### Long Center Lawn
- Occasional outdoor events
- Downtown skyline views

### Waterloo Park
- Moody Amphitheater (new)
- Downtown park setting

### Germania Insurance Amphitheater
- Large capacity (COTA area)
- Summer tours
