# SXSW Guide — Austin

## What Is SXSW

**South by Southwest** is Austin's mega-festival spanning music, film, and interactive (tech). It's transformed from indie music festival to global tech/culture event.

### The Three Pillars
| Track | Focus | When |
|-------|-------|------|
| Interactive | Tech, startups, future | First 4-5 days |
| Film | Independent cinema | Middle section |
| Music | Live music showcase | Final 4-5 days |

### Dates
- **When**: Mid-March (usually 10+ days)
- **2026**: Check sxsw.com for exact dates

---

## The SXSW Experience

### For Attendees
- **Badges**: $800-2,000+ depending on access
- **Wristbands**: Music-only, ~$200-300
- **Scale**: 400,000+ attendees
- **Feel**: Overwhelming, exciting, exhausting

### For Locals
- **Pros**: World-class acts, industry energy, free events
- **Cons**: Traffic, crowds, downtown becomes chaos
- **Strategy**: Embrace it or escape to Hill Country

---

## Badge Types

### Platinum Badge ($1,700+)
- All access: Interactive, Film, Music
- Priority entry to everything
- Networking events
- Best for: Industry professionals, investors

### Interactive Badge ($1,200+)
- Tech conference access
- Keynotes, panels, exhibitions
- Some music access
- Best for: Tech workers, entrepreneurs

### Music Badge ($800+)
- Official showcase access
- Industry events
- Film screenings
- Best for: Music industry, serious music fans

### Music Wristband ($200-300)
- Showcase entry (capacity permitting)
- No conference access
- Best for: Music fans on budget

### Film Badge ($1,000+)
- Film screenings (priority)
- Industry events
- Some music access
- Best for: Filmmakers, cinema lovers

---

## Without a Badge

### Free Options
- **Day parties**: Many free (RSVP required)
- **6th Street**: Unofficial shows everywhere
- **East Side**: Spillover shows
- **Brand activations**: Free entry, sometimes famous acts

### RSVP Culture
- Most free events require RSVP
- Use Do512.com, SXSW website
- RSVP early (weeks ahead)
- Some require "badge verification" but many don't

### Cost-Effective Strategy
1. RSVP to free day parties (start 2-3 weeks ahead)
2. Wander 6th Street at night
3. Check for unofficial showcases
4. Buy wristband only if you need guaranteed entry

---

## Music Showcases

### Official Showcases
- Badge/wristband required
- Hundreds of venues
- 2,000+ bands
- International acts
- Capacity-limited (arrive early)

### Day Parties
- Often free with RSVP
- Sponsored by brands, labels, publications
- Can see major acts for free
- Lines can be long

### Unofficial Shows
- Bars, restaurants, pop-ups
- No SXSW credential needed
- Often great discoveries
- Check Showlist Austin for listings

---

## Interactive Conference

### What It's Become
- Tech industry gathering
- Startup launches
- Keynotes from major figures
- Networking central

### Notable Past Speakers
- Elon Musk, Obama, Bernie Sanders
- Tech CEOs, culture figures
- Announcement platform for new products

### Best For
- Founders seeking investors
- Tech workers networking
- Anyone wanting pulse on trends

### Schedule
- Sessions 9am-6pm
- Trade show/exhibitions
- Evening events and parties
- Networking is 24/7

---

## Survival Guide

### Essentials
| Item | Why |
|------|-----|
| Comfortable shoes | Walking 10+ miles/day |
| Portable charger | Phone will die |
| Sunscreen | March sun is real |
| Light jacket | Nights cooler |
| Earplugs | Protect your ears |
| Water bottle | Stay hydrated |

### Transportation
- **Walk**: Best for downtown core
- **Rideshare**: Surge pricing brutal, use sparingly
- **Scooter**: Good for short hops
- **Car**: Don't even try downtown
- **Bike**: If you know the routes

### Food Strategy
- Eat before peak hours (5pm-8pm chaos)
- Many parties have free food
- East Side less crowded than downtown
- Make reservations for sit-down meals

### Sleep
- You won't get enough
- Plan recovery days
- Downtown hotels = convenience + noise
- Airbnb further out = quieter but harder access

---

## Best SXSW Experiences

### For Music Fans
1. **Discover**: See bands you've never heard of
2. **Day parties**: Free, often great lineups
3. **Stubbs or Mohawk showcases**: Guaranteed quality
4. **Late night**: Unofficial shows go until 2-4am

### For Tech/Startup
1. **Keynotes**: Major industry figures
2. **Trade show floor**: Product demos
3. **Networking events**: Industry-specific
4. **Startup pitch competitions**: See what's coming

### For Film Buffs
1. **Premieres**: World premieres of major films
2. **Q&As**: Directors, actors available
3. **Documentary focus**: Strong programming
4. **Midnight movies**: Cult film culture

---

## Day-by-Day Strategy

### Day 1
- Badge pickup (lines!)
- Get bearings
- One or two sessions/shows
- Don't overcommit

### Days 2-5
- Settle into rhythm
- Morning: recovery, coffee
- Afternoon: sessions or day parties
- Evening: showcases
- Late night: unofficial shows

### Final Days
- Music peaks
- Fatigue sets in
- Pick priorities carefully
- Leave time for "stumble upon" discoveries

---

## What NOT to Do

1. **Try to see everything** — Impossible. Choose wisely.
2. **Drive downtown** — Nightmare. Don't.
3. **Skip meals** — You need fuel.
4. **Ignore unofficial events** — Some of the best stuff.
5. **Stay in downtown hotel expecting sleep** — It's LOUD.
6. **Forget to RSVP** — Best free events fill up.
7. **Wear uncomfortable shoes** — Rookie mistake.

---

## For Austin Locals

### Embrace It
- Take time off work if you can
- See bands you'd never otherwise catch
- Day drink with purpose
- Network if relevant to your work

### Escape It
- Perfect time for Hill Country trip
- Avoid downtown entirely
- Work from home
- Let tourists have it

### Local Perks
- Some local discounts exist
- Know the back ways around traffic
- Can go home and recover
- No hotel costs

---

## Post-SXSW Recovery

### Physical
- Sleep
- Hydrate
- Walk slowly for a few days
- Ears may ring (see a doctor if persistent)

### Mental
- Decompression time
- Social exhaustion is real
- List of discovered bands to follow
- Process what you experienced

### Austin Returns to Normal
- Downtown empties
- Traffic improves
- Bars get quieter
- Locals reclaim the city
