# Local Services — Austin

## Setting Up Life in Austin

### First Week Checklist
- [ ] Driver's license or state ID
- [ ] Vehicle registration (if applicable)
- [ ] Utilities setup
- [ ] Internet service
- [ ] Bank account (if switching)
- [ ] Voter registration

---

## Driver's License & ID

### Texas DPS (Department of Public Safety)

**What you need:**
- Current out-of-state license (if applicable)
- Proof of identity (passport, birth certificate)
- Proof of Social Security number
- 2 proofs of Texas residency (utility bill, lease, etc.)
- Texas vehicle registration or out-of-state registration

**Timeline:**
- Must get Texas license within 90 days of establishing residency
- Appointments recommended (walk-ins have long waits)
- Schedule at texas.gov/driver

**Offices:**
- Multiple locations around Austin
- North Lamar is busiest
- Pflugerville often has shorter waits

**Cost:**
- License: $33 (6-year)
- ID: $16

**Tips:**
- Make appointment online (weeks out)
- Bring extra documentation
- Arrive early
- Download DL app for digital license

---

## Vehicle Registration

### If Bringing a Car to Texas

**Within 30 days, you need:**
1. Texas vehicle inspection
2. Title transfer
3. Registration

**Steps:**
1. Get Texas car insurance first
2. Get vehicle inspected (any certified station, ~$25)
3. Visit county tax office with:
   - Current title
   - Proof of insurance
   - Inspection report
   - Payment

**Cost:**
- Registration: ~$75/year
- Title transfer: ~$33
- Inspection: ~$25/year

**Travis County Tax Office:**
- Multiple locations
- Appointments available
- Bring all documentation

### Vehicle Inspection
- Required annually
- Any certified inspection station
- Tests: Emissions, safety
- ~$25.50
- Fix failures and re-inspect

---

## Utilities

### Electricity
**Austin Energy** (city-owned, no choice)
- Setup: austinenergy.com or 311
- Deposit: May be required
- Average bill: $100-200/month (higher summer)
- Renewable options available
- Time-of-use rates available

### Gas
**Texas Gas Service**
- Setup: texasgasservice.com
- Most homes use for heating/cooking
- Average: $30-60/month

### Water
**Austin Water**
- Setup: austintexas.gov/water
- Bundled with trash in most cases
- Average: $50-100/month

### Trash & Recycling
- City of Austin handles
- Curbside pickup
- Recycling included
- Composting available
- Large item pickup scheduled

### All-in-One
- Total utilities: $200-400/month typically
- Summer higher (AC)
- Winter lower

---

## Internet

### Providers
| Provider | Type | Speed | Price |
|----------|------|-------|-------|
| AT&T Fiber | Fiber | Up to 5 Gbps | $55-180/mo |
| Google Fiber | Fiber | 1-2 Gbps | $70-100/mo |
| Spectrum | Cable | Up to 1 Gbps | $50-110/mo |
| Grande | Fiber/Cable | Up to 1 Gbps | $45-80/mo |

### Coverage Notes
- Google Fiber limited to certain areas
- AT&T Fiber expanding
- Check address-specific availability
- Fiber preferred over cable

### Setup Tips
- Check availability before signing lease
- Self-install often available
- Schedule install during move-in week
- Negotiate rates (especially renewal)

---

## Banking

### Major Banks Present
- Chase
- Bank of America
- Wells Fargo
- USAA (if eligible)
- Frost Bank (Texas-based)

### Local/Regional
- Amplify Credit Union
- University Federal Credit Union
- Austin Telco FCU

### Recommendations
- Credit unions often better rates
- USAA excellent if military-connected
- Chase/BoA most ATMs
- Consider keeping existing bank + local option

---

## Postal Services

### USPS
- Standard mail delivery
- Change of address: usps.com
- Post office locations throughout

### Package Delivery
- UPS, FedEx, DHL all serve Austin
- Amazon lockers widely available
- Package theft common in apartments
- Consider delivery alternatives

### P.O. Boxes
- Available at most post offices
- Useful for secure delivery
- $20-200/year depending on size

---

## Healthcare Setup

### Finding a Doctor
- Insurance network matters
- Seton/Ascension network large
- St. David's network large
- Dell Medical School (UT) growing

### Insurance Options
- Employer-provided (best option)
- Healthcare.gov marketplace
- No state exchange (use federal)
- Open enrollment: Nov-Dec

### Urgent Care
- Multiple locations citywide
- $100-300 without insurance
- Good for non-emergencies
- Faster than ER

### Dental
- Not usually covered by medical insurance
- Separate dental plans available
- Many providers accept cash/credit

### Mental Health
- Growing availability
- Telehealth options
- Community resources available
- Integral Care (public)

---

## Voter Registration

### How to Register
- Online: votetexas.gov
- In person: County clerk, DPS offices
- By mail: Download and mail form

### Requirements
- US citizen
- Texas resident
- 18 by election day
- Not convicted of a felony (or completed sentence)

### Timeline
- Register 30 days before election
- Check registration at votetravis.com

### Voting
- In-person (Election Day or early voting)
- Vote-by-mail limited (65+, disability, etc.)
- Photo ID required

---

## Pets

### Dog Registration
- Required in Austin
- Online: austintexas.gov
- Rabies vaccination required
- $15-35/year

### Veterinarians
- Many options throughout city
- Emergency: Austin Vet Emergency
- Low-cost: Emancipet

### Dog Parks
- Many off-leash parks
- Auditorium Shores
- Zilker Park (areas)
- Red Bud Isle

### Pet-Friendly Culture
- Very dog-friendly city
- Many patios allow dogs
- Apartment pet policies vary
- Pet deposits: $200-500 common

---

## Libraries

### Austin Public Library
- 20+ branches
- Free library card for residents
- Digital resources (ebooks, audiobooks)
- Central Library downtown is stunning
- Events, classes, resources

### Services
- Free WiFi
- Computer access
- 3D printing
- Language learning
- Job search resources

---

## Community Resources

### 311
- Non-emergency city services
- Report issues (potholes, code violations)
- Utility questions
- General city information

### Recreation Centers
- PARD (Parks and Recreation)
- Swimming pools
- Sports leagues
- Classes and programs
- Affordable options

### Community Centers
- Various neighborhoods
- Events, classes, resources
- Meeting spaces

---

## Things That Might Surprise You

### What's Different in Texas
- No state income tax (but property taxes high)
- Liquor stores closed Sundays (before noon)
- Can't buy car from dealer on Sunday
- Beer/wine at grocery, liquor at liquor stores only
- Right turn on red (unless signed otherwise)
- Guns are common and legal
- Winters are mild (but summers brutal)
- Everything is big (portions, roads, distances)
- "Y'all" is standard vocabulary
- Tex-Mex is a religion
- High school football is serious business
