# Healthcare & Insurance — Austin

## Healthcare Reality

Texas has no state health exchange, limited Medicaid expansion, and high uninsured rates. Healthcare is primarily employer-based or private market.

**Key point:** Having good insurance matters significantly in Texas.

---

## Insurance Options

### Employer-Sponsored (Best Option)
- Most tech companies offer good plans
- Often PPO with broad network
- Employer pays 70-100% of premium
- This is the ideal scenario

### Healthcare.gov Marketplace
- Federal exchange (Texas doesn't run its own)
- Open enrollment: Nov 1 - Jan 15
- Special enrollment with qualifying events
- Subsidies available based on income

### Individual Plans (Outside Marketplace)
- Direct from insurers
- No subsidies
- May have better networks
- Compare carefully

### Health Sharing Ministries
- Not insurance (religious-based sharing)
- Lower monthly costs
- Limited coverage
- Doesn't satisfy ACA requirements (penalty removed anyway)

---

## Major Health Systems

### Seton / Ascension
- Largest system in Austin
- Dell Seton Medical Center (Level 1 trauma)
- Multiple hospitals and clinics
- Dell Medical School partnership

### St. David's
- Comprehensive network
- Multiple hospitals
- ER and specialty care
- Good suburban coverage

### Baylor Scott & White
- Growing Austin presence
- Regional healthcare system
- Good specialist access

### Austin Regional Clinic (ARC)
- Large physician group
- Primary care and specialists
- Many locations
- Accepts most insurance

---

## Finding Care

### Primary Care
- Essential for ongoing health
- ARC has many providers
- Seton/Ascension network
- St. David's network
- Independent practices

### Specialists
- Available through health systems
- Referral often needed (HMO)
- Wait times vary
- Dell Medical School specialists

### Urgent Care
- Multiple options throughout city
- $100-300 without insurance
- Faster than ER for non-emergencies
- Many open evenings/weekends

### Emergency
- Dell Seton (Level 1 trauma)
- St. David's locations
- Call 911 for emergencies
- ER is expensive without insurance

---

## Cost Expectations

### With Good Insurance
| Service | Typical Cost |
|---------|--------------|
| Primary care visit | $20-50 copay |
| Specialist visit | $30-75 copay |
| Urgent care | $50-100 copay |
| ER visit | $200-500 copay |
| Generic prescriptions | $5-30 |

### Without Insurance
| Service | Typical Cost |
|---------|--------------|
| Primary care visit | $100-250 |
| Specialist visit | $200-500 |
| Urgent care | $150-300 |
| ER visit | $500-3,000+ |
| Lab work | $50-500 |

### Monthly Premiums (Marketplace)
| Plan Type | Individual | Family |
|-----------|------------|--------|
| Bronze | $200-350 | $600-1,000 |
| Silver | $300-500 | $900-1,400 |
| Gold | $400-600 | $1,200-1,800 |

*Subsidies reduce these significantly for qualifying incomes*

---

## Mental Health

### Availability
- Growing but not sufficient
- Telehealth expanding access
- Insurance coverage varies
- Long wait times for psychiatrists

### Resources
| Resource | Type |
|----------|------|
| Integral Care | Public mental health |
| NAMI Austin | Support and advocacy |
| Austin Anxiety and Behavioral Health | Private practice |
| Telehealth (BetterHelp, etc.) | Remote therapy |

### Crisis
- 911 for emergencies
- 988 Suicide & Crisis Lifeline
- Integral Care crisis line: 512-472-4357

---

## Dental & Vision

### Dental Insurance
- Usually separate from medical
- Employer may offer
- Marketplace doesn't include
- Many pay out-of-pocket

### Dental Costs (Without Insurance)
| Service | Cost |
|---------|------|
| Cleaning | $100-200 |
| Filling | $150-300 |
| Crown | $800-1,500 |
| Root canal | $700-1,200 |

### Vision
- Often separate coverage
- Annual exams: $100-200
- Glasses: $200-500
- Contacts: Varies

### Low-Cost Options
- Dental schools (UT Health San Antonio)
- Community health centers
- Sliding scale clinics

---

## For New Residents

### First Steps
1. Determine insurance status (employer, marketplace, etc.)
2. Find primary care doctor (use insurance directory)
3. Establish care (annual physical)
4. Know nearest urgent care and ER
5. Set up pharmacy (CVS, Walgreens, HEB)

### Transferring Records
- Request from previous providers
- HIPAA allows access
- Many systems accept electronic transfer
- Keep copies of important records

---

## Special Populations

### Families
- Pediatricians available through all systems
- Dell Children's Hospital for serious issues
- CHIP for children's coverage
- WIC for qualifying families

### Pregnancy
- OB/GYN networks strong
- Hospital choice matters
- Insurance coverage varies widely
- Doulas and midwives available

### Seniors
- Medicare applies as usual
- Supplement plans available
- Medicare Advantage options
- Seton and St. David's both serve

### Veterans
- VA Austin Outpatient Clinic
- VA hospital in San Antonio (1 hour)
- Community Care for closer options

---

## Pharmacies

### Major Chains
- CVS
- Walgreens
- HEB Pharmacy (local, often cheaper)
- Walmart
- Costco (membership not required for pharmacy)

### Specialty
- For complex medications
- Insurance may require specific pharmacy
- Mail order options

### Savings Tips
- GoodRx for price comparison
- Generic when available
- Ask about cash price (sometimes cheaper)
- 90-day supplies often discounted
- HEB often has good prices

---

## Texas Healthcare Context

### No Medicaid Expansion
- Texas didn't expand Medicaid under ACA
- Gap population exists (too much for Medicaid, too poor for subsidies)
- This is a significant coverage gap

### Uninsured Rate
- Texas has highest uninsured rate in US (~17%)
- Many working people lack coverage
- Charity care available but limited

### Political Landscape
- Healthcare is state political issue
- Changes possible depending on leadership
- Federal policy affects options

---

## Resources

### Finding Providers
- Insurance company directories
- Zocdoc
- Healthgrades
- Yelp (for reviews)

### Financial Assistance
- Hospital charity care programs
- Community health centers (sliding scale)
- Federally Qualified Health Centers
- Prescription assistance programs

### Information
- Healthcare.gov
- Texas Health and Human Services
- Austin Public Health Department
