# Practical Food Guide — Austin

## Tipping

### Standard Expectations
| Service Type | Expected Tip |
|--------------|--------------|
| Table service | 18-22% |
| Counter service | 15-20% |
| BBQ | 15-20% (yes, tip at BBQ) |
| Food trucks | 15-20% |
| Coffee | $1-2 or 15-20% |
| Bars | $1-2/drink or 18-20% |
| Delivery | 15-20% |

### Notes
- Austin service workers often rely on tips
- iPad tip screens are everywhere (15/20/25% presets)
- No tip = noticed and remembered
- BBQ lines involve real labor — tip those workers

---

## Hours & Timing

### Typical Restaurant Hours
| Meal | Hours |
|------|-------|
| Breakfast | 7am-11am |
| Brunch (weekends) | 9am-3pm |
| Lunch | 11am-2pm |
| Happy hour | 4pm-7pm |
| Dinner | 5pm-10pm |
| Late night | 10pm-2am (limited) |

### 24-Hour Options
- Kerbey Lane Cafe (multiple locations)
- Magnolia Cafe (multiple locations)
- 24 Diner (North Lamar)
- Some taco shops

### When Things Are Closed
- **Monday** — Many restaurants closed
- **Sunday** — Some brunch-only
- **2-5pm** — Many close between lunch and dinner
- **Holidays** — Call ahead

---

## Reservations

### Need Reservations
- Uchi / Uchiko
- Emmer & Rye
- Justine's
- Barley Swine
- Any $$$+ on weekends

### Apps/Methods
| Platform | Notes |
|----------|-------|
| Resy | Most common in Austin |
| OpenTable | Some spots |
| Yelp | Limited |
| Direct | Call or website |

### Walk-In Strategy
- **Bar seating** — Often available, same menu
- **Early bird** — 5:30pm usually open
- **Late** — After 9pm clears up
- **Weeknights** — Much easier
- **Cancellation lists** — Ask to be added

---

## Dietary Accommodations

### Vegetarian
- **Generally easy** — Most restaurants accommodate
- **Dedicated spots**: Bouldin Creek Cafe, Counter Culture
- **Tex-Mex**: Bean-based options everywhere
- **BBQ challenge**: Sides only at most spots

### Vegan
- **Growing scene** — Austin is vegan-friendly
- **Dedicated**: Arlo's, Counter Culture, Beer Plant
- **Ask servers** — Most kitchens can adapt
- **BBQ**: Some spots do jackfruit "brisket"

### Gluten-Free
- **Widely available** — Ask your server
- **Cross-contamination** — Ask about shared fryers
- **BBQ** — Meat is naturally GF (skip bread)
- **Dedicated bakeries** — Wildwood, others

### Halal
- **Limited** — Halal Guys chain exists
- **Some Mediterranean** — Ask specifically
- **Not widespread** — Plan ahead

### Kosher
- **Very limited** — No dedicated restaurants
- **Self-catering** — Often necessary
- **HEB** — Some kosher products

### Allergies
- **Inform server** — Most take seriously
- **Peanut/Tree nut** — Asian cuisine caution
- **Shellfish** — Easy to avoid
- **Cards/apps** — Consider allergy cards in multiple languages

---

## Budget Strategies

### Cheapest Good Food
| Option | Cost | Examples |
|--------|------|----------|
| Breakfast tacos | $8-12 | Veracruz, Tacodeli |
| Food trucks | $10-15 | East Austin clusters |
| Taco trucks | $8-12 | Street tacos |
| Fast casual | $10-15 | P. Terry's, Torchy's |
| Pho/Asian | $12-18 | Pho Saigon, Madam Mam's |

### Happy Hour Deals
- **Best hours**: 4-7pm typically
- **Common deals**: Half-price apps, $5-7 drinks
- **Research**: Check websites/Yelp for specifics
- **Best spots**: Rainey Street, South Lamar

### Value Moves
1. **Lunch specials** — Dinner menus at lunch prices
2. **Food trucks** — Chef quality, trailer prices
3. **Counter service** — Skip service charge
4. **BYOB** — Some trailers/parks allow
5. **Meal prep** — HEB is excellent

---

## Payment

### What's Accepted
- **Credit cards** — Almost everywhere
- **Cash** — Some food trucks prefer
- **Apple Pay/tap** — Growing
- **Venmo** — Some trucks

### Cash-Only Spots (Rare but Exist)
- Some food trucks
- Some old-school taquerias
- Always check before ordering

---

## Allergies & Cross-Contamination

### High-Risk Cuisines for Allergies
| Allergy | Watch Out For |
|---------|---------------|
| Peanut | Thai, Chinese, Vietnamese |
| Tree nut | Desserts, salads |
| Shellfish | Seafood restaurants, fried items |
| Dairy | Mexican (queso), Italian |
| Gluten | Fried foods, sauces, beer |

### Communication Tips
- Tell server AND manager
- Ask about shared fryers
- Ask about sauce ingredients
- Don't assume menu accuracy

---

## Weather Considerations

### Summer (Jun-Sep)
- **Avoid outdoor seating** — 100°F+
- **AC essential** — Some patios misted
- **Hydrate** — Drink water, not just alcohol
- **Early/late** — Eat before noon or after 8pm

### Patio Season
- **Best**: March-May, October-November
- **Great patios**: Guero's, Rainey Street bars, Hotel San Jose

### Rain
- **Flash floods** — Roads can flood suddenly
- **Many patios covered** — Check ahead
- **Traffic worse** — Plan extra time

---

## For Families

### Kid-Friendly Spots
| Restaurant | Notes |
|------------|-------|
| Kerbey Lane | Pancakes, crayons |
| P. Terry's | Fast, easy |
| Rudy's | BBQ, fast service |
| Amy's Ice Cream | Always a hit |
| Pinthouse Pizza | Good for parents too |

### Family Meal Strategy
- Earlier is better (5:30-6pm)
- Counter service less stressful
- Food trucks = kids can run around
- Weekend brunch can be chaotic

---

## Restaurant Week

### Austin Restaurant Weeks
- **When**: Typically spring and fall
- **What**: Prix-fixe menus at discounts
- **Value**: Great way to try upscale spots
- **Book**: Reservations fill fast
- **Check**: austinrestaurantweeks.com

---

## Food Delivery

### Services Available
| Service | Coverage |
|---------|----------|
| DoorDash | Best coverage |
| Uber Eats | Good |
| Grubhub | Decent |
| Favor | Texas-based, good |
| Postmates | Limited now |

### Delivery Tips
- Fees add up fast ($5-10+ per order)
- Tip well (drivers depend on it)
- Popular times = longer waits
- BBQ doesn't travel well (eat fresh)

---

## Grocery & Self-Catering

### Grocery Stores
| Store | Notes |
|-------|-------|
| HEB | Texas institution, excellent |
| Whole Foods | Austin-born, headquarters here |
| Central Market | Upscale HEB |
| Trader Joe's | Limited locations |
| Costco | Multiple locations |

### HEB Tips
- **Best prepared foods** — Ready-to-eat excellent
- **Texas products** — Good local selection
- **Bakery** — Fresh, good value
- **Produce** — Quality varies by location

### Farmers Markets
| Market | When | Where |
|--------|------|-------|
| SFC Downtown | Saturday AM | Republic Square |
| SFC Mueller | Sunday AM | Mueller |
| Hope | Sunday AM | Plaza Saltillo |
| Barton Creek | Saturday AM | Barton Creek Mall |
