# Food Scene Overview — Austin

## What Makes Austin's Food Scene Special

### The Pillars
1. **BBQ** — Texas brisket is religion here. Franklin, la Barbecue, and dozens more
2. **Tex-Mex** — Breakfast tacos are daily ritual. Queso is a food group
3. **Food Trucks** — Austin pioneered the upscale food trailer movement
4. **Fusion** — Asian-Texan, Southern-Mexican, global influences
5. **Farm-to-Table** — Strong local sourcing, Hill Country farms

### Evolution
- **Pre-2010**: Tex-Mex dominated, BBQ was local secret
- **2010-2015**: Franklin goes viral, food trucks explode, national attention
- **2015-2020**: Celebrity chefs arrive, fine dining scene develops
- **2020-present**: Post-pandemic renaissance, diverse cuisines flourishing

---

## Cuisine Breakdown

| Cuisine | Importance | Where to Start |
|---------|------------|----------------|
| BBQ | **Essential** | Franklin, la Barbecue, Terry Black's |
| Tex-Mex | **Essential** | Veracruz, Matt's El Rancho, Guero's |
| Breakfast Tacos | **Essential** | Veracruz, Tacodeli, Torchy's |
| Food Trucks | **Essential** | East Austin clusters, South First |
| Japanese | Strong | Uchi, Ramen Tatsu-ya, Kemuri |
| Thai | Strong | Dee Dee, Thai Kun, Sap's |
| Vietnamese | Growing | Elizabeth Street, Pho Saigon |
| Indian | Strong | Clay Pit, Bombay Bistro |
| Italian | Good | Juniper, L'Oca d'Oro, Intero |
| Fine Dining | Excellent | Uchi, Emmer & Rye, Odd Duck |

---

## Meal by Meal

### Breakfast (7am-11am)
- **Breakfast tacos** — The Austin way. Every day if you want.
- **Diners** — Kerbey Lane, Magnolia Cafe, 24 Diner
- **Upscale brunch** — Launderette, Josephine House, Juniper
- **Kolaches** — Czech pastries, popular grab-and-go

### Lunch (11am-2pm)
- **BBQ** — If going to Franklin, you're eating lunch
- **Food trucks** — Quick, affordable, excellent
- **Tex-Mex** — Matt's El Rancho, Chuy's, Trudy's
- **Fast casual** — P. Terry's, Mighty Fine, Hopdoddy

### Happy Hour (4pm-7pm)
- Most restaurants participate
- Half-price apps common
- Craft cocktail scene strong
- Rainey Street, East 6th best areas

### Dinner (7pm-10pm)
- **Fine dining** — Uchi, Emmer & Rye, Launderette
- **BBQ** — Some places open for dinner (Terry Black's)
- **Tex-Mex** — Matt's, Fonda San Miguel, El Alma
- **Everything else** — Full range available

### Late Night (10pm-2am)
- **24-hour** — Kerbey Lane, Magnolia Cafe, 24 Diner
- **Late kitchen** — Many bars serve until midnight+
- **Food trucks** — Some operate late, especially weekends
- **Pizza** — Home Slice, Via 313 late-night window

---

## Price Ranges

| Category | Price Range | Examples |
|----------|-------------|----------|
| Food truck | $8-15 | East Austin trailers |
| Casual | $12-25 | Torchy's, P. Terry's, Chuy's |
| Mid-range | $25-50 | Odd Duck, Dai Due, Uchiko |
| Fine dining | $75-150+ | Uchi, Emmer & Rye, Barley Swine |
| BBQ | $18-35 | Franklin, la Barbecue |
| Breakfast tacos | $3-6 | Veracruz, Tacodeli |

### Tipping
- **Table service**: 18-22% expected
- **Counter service**: 15-20% (yes, including BBQ — they work hard)
- **Food trucks**: 15-20%
- **Coffee shops**: $1-2 or 15-20%

---

## By Neighborhood

### East Austin
**Best for**: Food trucks, tacos, trendy restaurants, BBQ
- Franklin Barbecue
- Veracruz All Natural
- Kemuri Tatsu-ya
- Suerte
- Dai Due

### South Congress (SoCo)
**Best for**: Brunch, people-watching, upscale casual
- Home Slice Pizza
- Guero's Taco Bar
- Perla's
- Elizabeth Street Cafe

### Downtown
**Best for**: Happy hour, fine dining, convenience
- Uchi
- Wu Chow
- Garrison
- Perry's Steakhouse

### Rainey Street
**Best for**: Bar food, upscale casual, groups
- Emmer & Rye
- Banger's
- Craft Pride (beer)
- Container Bar

### South Lamar
**Best for**: Diverse options, entertainment district
- Uchi
- Matt's El Rancho
- Loro
- Odd Duck

### North Austin / Domain
**Best for**: Chains, upscale suburban
- North Italia
- True Food Kitchen
- Eddie V's
- Domain restaurants

---

## Dietary Considerations

### Vegetarian/Vegan
- **Strong scene** — Austin is vegan-friendly
- **Dedicated spots**: Bouldin Creek Cafe, Counter Culture, Arlo's (vegan food truck)
- **BBQ alternative**: Jackfruit "brisket" at some spots
- **Tex-Mex**: Bean-based options everywhere

### Gluten-Free
- Most restaurants can accommodate
- Dedicated GF bakeries exist
- BBQ is naturally GF (meat, no bun)
- Ask about cross-contamination

### Halal
- Growing options
- Halal Guys (chain)
- Some Mediterranean spots
- Limited compared to larger metros

### Kosher
- Very limited
- No dedicated kosher restaurants
- Self-catering often necessary

---

## Reservations & Wait Times

### Need Reservations
- Uchi / Uchiko
- Emmer & Rye
- Odd Duck
- Launderette
- Most fine dining

### Expect Waits (No Reservations)
- Franklin Barbecue (3-4 hours)
- la Barbecue (1-2 hours)
- Torchy's (weekends)
- Home Slice (dinner)

### Walk-In Friendly
- Most Tex-Mex
- Food trucks (always)
- Casual spots
- Terry Black's BBQ
- Counter service BBQ

### Apps/Services
- Resy (most common)
- OpenTable
- Yelp Reservations
- Some direct booking only

---

## Food Events & Festivals

| Event | When | What |
|-------|------|------|
| Austin Food & Wine Festival | April | Celebrity chefs, tastings |
| Hot Luck | May | Franklin-led BBQ festival |
| Texas Monthly BBQ Fest | Fall | Best BBQ in state |
| Austin Restaurant Weeks | Various | Prix-fixe deals |
| Tacolandia | Fall | Taco festival |

---

## Austin Food Rules

1. **Breakfast tacos are not negotiable** — Eat them. Often.
2. **BBQ requires commitment** — Either wake up early or accept lines
3. **Food trucks are not lesser** — Some are best in city
4. **Queso is its own food group** — Accept this
5. **Tip generously** — Service industry is Austin's backbone
6. **Tex-Mex is not Mexican food** — It's its own thing. Respect it.
7. **Happy hour is culture** — Participate
8. **Late night eating is expected** — Many options exist
