# BBQ Guide — Austin

## The Philosophy

Texas BBQ is centered on **beef brisket**, slow-smoked with post oak wood. The meat is the star — sauce is optional and often not needed.

### Texas BBQ vs Others
| Style | Focus | Sauce | Wood |
|-------|-------|-------|------|
| **Texas** | Beef brisket | Optional, tomato-based | Post oak |
| Carolina | Pork | Vinegar or mustard | Hickory |
| Kansas City | Everything | Sweet, thick | Hickory |
| Memphis | Ribs | Dry or wet | Hickory |

**In Austin**: You're eating Texas BBQ. Brisket is king.

---

## The Tier System

### Tier 1: Legendary (Worth Any Wait)

#### Franklin Barbecue
- **The standard** — Aaron Franklin made Austin BBQ famous
- **Wait**: 3-4 hours (arrive 8am for 11am opening)
- **What to order**: Brisket (fatty end), pork ribs, sausage
- **Pro tip**: Order ahead (limited but possible)
- **Cost**: ~$28-35/person
- **Location**: East Austin

#### la Barbecue
- **The rival** — Many locals prefer it
- **Wait**: 1-2 hours
- **What to order**: Brisket, beef ribs (Saturday)
- **Pro tip**: Better line experience (beer, shade)
- **Cost**: ~$25-32/person
- **Location**: East Austin

### Tier 2: Excellent (Still Amazing)

#### Micklethwait Craft Meats
- **What**: Trailer, seasonal sides, housemade everything
- **Wait**: 30-60 min
- **Specialty**: Jalapeno cheese sausage, creative sides
- **Cost**: ~$22-28/person

#### Interstellar BBQ
- **What**: Newcomer that earned fast reputation
- **Wait**: Variable
- **Specialty**: Consistency, all meats excellent
- **Cost**: ~$25-30/person

#### LeRoy and Lewis
- **What**: Food truck with modern approach
- **Specialty**: Beef cheeks, creative takes
- **Wait**: 30-60 min

### Tier 3: No Wait, Still Great

#### Terry Black's Barbecue
- **What**: Large capacity, no wait
- **Best for**: Groups, tourists, any time
- **Quality**: Very good (not legendary but solid 8/10)
- **Cost**: ~$22-28/person

#### Stiles Switch BBQ
- **What**: No-frills counter service
- **Best for**: Lunch, no hassle
- **Specialty**: Consistency

#### Valentina's Tex Mex BBQ
- **What**: BBQ + Tex-Mex fusion
- **Specialty**: Brisket breakfast tacos, smoked meats in tacos
- **Location**: South Austin (drive worth it)

### Tier 4: Solid Options

- **Rudy's** — Chain, but consistent, gas station vibes
- **Salt Lick** — Tourist destination, all-you-can-eat option
- **County Line** — Old school, good ribs
- **Black's Barbecue** — Lockhart legend with Austin location

---

## What to Order

### The Essentials
| Cut | Description | Order |
|-----|-------------|-------|
| **Brisket (fatty)** | Fattier point end, more flavor | Always |
| **Brisket (lean)** | Leaner flat, more "meaty" | If you prefer lean |
| **Pork ribs** | St. Louis or spare ribs | Highly recommended |
| **Beef ribs** | Massive, expensive, incredible | If available |
| **Sausage** | House-made at good spots | Try the jalapeno cheese |
| **Pulled pork** | Less common in TX | If offered |
| **Turkey** | Smoked breast | Underrated, good lean option |

### How to Order
1. **By the pound** — Most places sell by weight
2. **Plates** — Include sides, bread
3. **Sandwiches** — Convenient but less meat
4. **Family packs** — Good for groups

### Sample Order (2 People)
- 1/2 lb brisket (moist/fatty)
- 1/4 lb sausage
- 2 ribs
- 2 sides (potato salad, beans)
- = ~$50-60 total

---

## The Line Experience

### Franklin Strategy
1. **Arrive 8:00-8:30am** for 11am opening
2. **Bring chairs** — They provide some
3. **Bring friends** — Line is social
4. **Beer is allowed** — Many bring coolers
5. **They do sell out** — Being early matters
6. **Weekdays slightly shorter** than weekends

### la Barbecue Strategy
1. **Arrive 10:00-10:30am** for 11am opening
2. **Shaded, more comfortable** line area
3. **Beer sold on-site**
4. **More forgiving** if you arrive later

### Skip the Line Options
- **Terry Black's** — No wait, very good
- **Stiles Switch** — No wait, solid
- **Pre-order** — Franklin offers limited online ordering
- **Weekday lunch** — Lines shorter

---

## BBQ Etiquette

### Do
- Order by weight ("half pound of brisket")
- Ask for "moist" or "fatty" brisket (better)
- Try without sauce first
- Tip 15-20% at counter
- Eat with hands (plastic gloves often provided)
- Get extra white bread (free)

### Don't
- Ask for sauce before tasting
- Request well-done brisket
- Complain about prices (it's intensive labor)
- Expect quick service (good BBQ takes time)
- Skip the sausage

---

## Day Trips: Lockhart

**"BBQ Capital of Texas"** — 30 miles south of Austin

### The Big Three

#### Kreuz Market
- **Established**: 1900
- **Style**: Old school, no forks, no sauce
- **Order**: Prime rib, shoulder clod
- **Vibe**: Historic, no-frills

#### Black's Barbecue
- **Established**: 1932
- **Style**: More traditional sides
- **Order**: Brisket, sausage rings
- **Vibe**: Family-friendly

#### Smitty's Market
- **Established**: 1999 (split from Kreuz)
- **Style**: Enter through the smoke room
- **Order**: Everything, experience matters
- **Vibe**: Atmospheric

### Lockhart Strategy
- Go on a weekday
- Hit 2 of 3 spots
- 1 hour from Austin
- Make a half-day trip

---

## BBQ Seasons

### Best Time for BBQ
- **Fall/Winter** — Comfortable outdoor eating
- **Spring** — Pleasant, before extreme heat
- **Summer** — Go early, AC inside at some spots

### When Lines Are Shortest
- **Weekday lunches** — Local crowd, manageable
- **January-February** — Tourism low
- **Bad weather** — Brave souls rewarded

### When to Avoid
- **SXSW** — Everything packed
- **Summer weekends** — Hot + tourists
- **Major holidays** — Many closed or limited

---

## Price Reality (2026)

| Item | Price Range |
|------|-------------|
| Brisket (per lb) | $24-32 |
| Pork ribs (per lb) | $18-24 |
| Beef rib (each) | $35-50 |
| Sausage (per link) | $5-8 |
| Turkey (per lb) | $18-22 |
| Two-meat plate | $22-28 |
| Three-meat plate | $28-35 |

**Budget for two people**: $50-70 including drinks

---

## Insider Tips

1. **Fatty brisket > lean** — Always
2. **The bark is the prize** — Crusty exterior
3. **Beef ribs on weekends** — Many spots only Saturday
4. **Breakfast tacos at Valentina's** — BBQ + tacos = perfection
5. **Blue Bell ice cream after** — Texas tradition
6. **White bread is functional** — Use it to grab meat
7. **Pickles and onions are palate cleansers** — Free at most spots
8. **The line is part of it** — Embrace the culture
