# Schools & Education — Austin

## School District Overview

Austin area has multiple school districts. Where you live determines your district.

### Major Districts
| District | Areas | Rating | Notes |
|----------|-------|--------|-------|
| Eanes ISD | Westlake | A+ | Top in Texas, wealthy |
| Austin ISD | Central Austin | B+ | Large, diverse, variable |
| Round Rock ISD | Round Rock, parts north | A | Strong, suburban |
| Leander ISD | Cedar Park, Leander | A | Growing rapidly |
| Pflugerville ISD | Pflugerville | B+ | Diverse, improving |
| Lake Travis ISD | Lakeway | A | Suburban, strong |
| Manor ISD | Manor | B | Improving |
| Del Valle ISD | Southeast | C+ | Working class |

---

## Austin ISD (AISD)

### Overview
- Largest district in area
- 80+ schools
- 75,000+ students
- Very diverse student body
- Performance varies significantly by school

### Top AISD Schools
**Elementary:**
- Highland Park Elementary
- Casis Elementary
- Lee Elementary
- Barton Hills Elementary
- Doss Elementary

**Middle:**
- O. Henry Middle School
- Kealing Middle School (magnet)
- Murchison Middle School

**High:**
- Liberal Arts and Science Academy (LASA) — Magnet, highly competitive
- Austin High School
- Bowie High School
- Anderson High School

### Magnet Programs
- LASA — Liberal Arts and Science Academy (ranked nationally)
- Kealing — Middle school magnet
- Ann Richards School — All-girls STEM
- Various specialty programs

---

## Eanes ISD (Westlake)

### Why It's #1 in Texas
- Extremely well-funded (wealthy tax base)
- High-performing students
- Strong college placement
- Excellent facilities
- Top teachers

### Schools
- Westlake High School — Legendary academics and sports
- Hill Country Middle School
- Multiple elementary schools

### The Trade-Off
- Must live in Westlake area
- Home prices: $1M+
- Competitive, high-pressure environment
- Less diversity

---

## Round Rock ISD

### Profile
- Large suburban district
- High performance
- More affordable than Eanes
- Good balance of quality and accessibility

### Notable Schools
- Westwood High School — Strong academics
- Round Rock High School
- Multiple quality elementaries

### Considerations
- Growing rapidly
- Some schools crowded
- Generally safe and high-performing

---

## Private Schools

### Top Options
| School | Type | Grades | Tuition |
|--------|------|--------|---------|
| St. Andrew's | Episcopal | PreK-12 | $25K-35K |
| St. Stephen's | Episcopal | 6-12 | $30K-45K |
| Austin Waldorf | Waldorf | PreK-12 | $15K-20K |
| Regents School | Classical Christian | PreK-12 | $12K-18K |
| Griffin School | Progressive | K-8 | $15K-22K |
| St. Gabriel's | Catholic | PreK-8 | $10K-15K |

### Considerations
- Significantly more expensive
- May offer different educational philosophy
- Smaller class sizes
- Various religious affiliations
- Some have competitive admissions

---

## Charter Schools

### Options
- KIPP Austin
- Harmony Science Academy
- Idea Public Schools
- University of Texas Elementary (limited)

### How They Work
- Public schools, independently operated
- Lottery admission
- No tuition
- Variable quality

---

## UT Austin

### Overview
- Flagship public university
- 51,000+ students
- Top 50 nationally (higher in many programs)
- Research powerhouse

### Strong Programs
- Computer Science (Top 10)
- Engineering (Top 10)
- Business (McCombs — Top 20)
- Law (Top 15)
- Natural Sciences
- Communications

### Admissions
- Competitive (especially out-of-state)
- Top 6% Texas students auto-admit
- Out-of-state: ~8% acceptance
- In-state: ~30% acceptance

### Campus Life
- Central Austin location
- Football culture
- Active student life
- Research opportunities
- Strong internship pipeline

### Graduate Programs
- Strong across disciplines
- Dell Medical School (new)
- Business, Law, Engineering standouts
- Research funding strong

---

## Other Colleges

### Austin Community College (ACC)
- Two-year college
- Multiple campuses
- Affordable education
- Transfer pathway to UT

### St. Edward's University
- Private Catholic
- 4,000 students
- Good regional reputation
- South Austin campus

### Concordia University Texas
- Private Lutheran
- Small (~2,500)
- Northwest Austin

### Texas State (San Marcos)
- 30 minutes south
- Large public university
- Growing reputation
- More accessible admission

---

## Choosing Schools (For Families)

### Research Process
1. Identify where you want to live (district determined)
2. Research specific schools in that area
3. Visit schools if possible
4. Consider specialty/magnet programs
5. Look at test scores, but also culture

### Resources
- GreatSchools.org — Ratings
- Niche.com — Rankings and reviews
- Texas Academic Performance Reports
- School websites
- Talk to current parents

### Trade-Offs
| Priority | Best Option |
|----------|-------------|
| Best schools regardless of cost | Westlake (Eanes ISD) |
| Good schools, more affordable | Round Rock, Cedar Park |
| Urban + good schools | Circle C (AISD), Zilker area |
| Diversity | Central AISD, Pflugerville |

---

## Childcare & Preschool

### Types
- Daycare centers
- Home daycares
- Preschools (3-5)
- Pre-K programs (public)

### Costs
| Type | Monthly Cost |
|------|--------------|
| Infant daycare | $1,500-2,500 |
| Toddler daycare | $1,200-2,000 |
| Preschool | $1,000-2,000 |
| Pre-K (public) | Free (if eligible) |

### Finding Care
- Care.com
- Winnie.com
- Local parent groups
- Tour facilities before committing
- Check licensing and reviews

### Waitlists
- Start early (some from pregnancy)
- Desirable programs fill fast
- Apply to multiple options

---

## Homeschooling

### Texas Rules
- Minimal regulation
- No registration required
- Curriculum parent's choice
- Must cover reading, spelling, grammar, math, citizenship

### Support
- Austin homeschool co-ops
- Curriculum options
- Sports leagues (some allow homeschool)
- Growing community

---

## Special Education

### AISD Services
- Required by federal law
- IEP process
- Varies by school
- Advocate if needed

### Private Options
- Schools specializing in learning differences
- Therapy services
- Tutoring support

### Resources
- Texas Project FIRST
- Arc of Texas
- Local support groups
