# Culture & Customs — Austin

## Austin Identity

### "Keep Austin Weird"
The unofficial slogan captures Austin's spirit:
- Support local businesses over chains
- Embrace individuality and creativity
- Resist homogenization
- Celebrate the unusual

**Reality check:** Rapid growth has changed Austin. Longtime residents mourn "old Austin." Newcomers should acknowledge this tension.

### Texas vs Austin
Austin is Texas's liberal island:
- Progressive politics in conservative state
- Tech culture vs traditional Texas
- Both identities coexist
- Austin is still fundamentally Texan

---

## Social Norms

### Friendliness
- Strangers talk to each other (normal here)
- Small talk expected (grocery store, bars, anywhere)
- "How are you?" is greeting, not question
- People are generally helpful

### Directness
- Texans are friendly but direct
- Say what you mean
- Don't confuse friendliness with softness
- Respect is earned through authenticity

### Pace of Life
- More relaxed than NYC or SF
- Work-life balance valued
- Outdoor activities integrated into life
- Late starts common (not a 7am culture)

### "Y'all"
- Standard vocabulary, not affectation
- Gender-neutral, useful
- Embrace it

---

## Food Culture

### Breakfast Tacos
- Daily ritual for many
- Acceptable breakfast every day
- Strong opinions on best spots
- Green salsa preferred locally

### BBQ
- Serious business
- Lines are accepted
- Don't ask for sauce before tasting
- Brisket is primary, everything else is secondary

### Tex-Mex
- Not Mexican food (distinct cuisine)
- Queso is essential
- Margaritas are standard
- Chips and salsa are appetizer

### Dining Culture
- Casual dress everywhere
- Reservations for upscale only
- Patios are lifestyle
- Tipping: 18-22%

---

## Music Culture

### "Live Music Capital of the World"
- Taken seriously
- Music everywhere, every night
- Free shows common
- Support local artists

### Genre Diversity
- Country/Honky Tonk (obviously Texas)
- Rock/Indie (Red River district)
- Blues (Antone's tradition)
- Singer-songwriter (Saxon Pub)
- Everything else too

### Music Etiquette
- Listening rooms: Don't talk during songs
- Bar shows: More casual
- Tip the band
- Buy merch
- Arrive for openers (support them)

---

## Outdoor Culture

### Lifestyle Integration
- Outdoors are daily, not weekend-only
- Morning runs on trail: Standard
- Kayaking after work: Common
- Hiking: Accessible year-round

### Lady Bird Lake
- Heart of Austin outdoor life
- Running, biking, kayaking, paddleboarding
- Free access
- Social scene unto itself

### Swimming
- Barton Springs is religion
- Natural spring pools throughout
- Year-round swimmers exist
- Post-swim hangout culture

### Heat Adaptation
- Locals adjust activity to weather
- Early morning or evening in summer
- AC is non-negotiable
- Hydration is serious

---

## Work Culture

### Tech Casual
- Jeans and t-shirt standard
- Suits are rare (and suspicious)
- Flip-flops in some offices
- Dress code essentially doesn't exist

### Remote/Hybrid
- Most tech companies offer flexibility
- Coffee shop meetings common
- Co-working spaces throughout
- Work-from-home normalized

### Work-Life Balance
- Better than coastal tech hubs (generally)
- Outdoor activities not sacrificed
- Happy hour is institution
- Weekends are protected

### Meeting Culture
- Breakfast meetings at taco spots
- Coffee meetings standard
- Walking meetings (when cool enough)
- Happy hour meetings

---

## Social Life

### Making Friends
- Activity-based friendships common
- Running clubs, cycling groups
- Volleyball, climbing gyms
- Meetups for everything

### Dating Scene
- Large single population
- Swipe culture present
- Activities as dates (hikes, music)
- Austin is relationship-friendly

### Nightlife
- Diverse options by neighborhood
- East Austin: Hip, creative
- Rainey: Upscale, 25-40
- 6th Street: Young, rowdy
- Red River: Music-focused

### LGBTQ+ Scene
- Welcoming city
- Pride events
- 4th Street historically
- Cheer Up Charlie's, other venues
- Contrast with state politics

---

## Community Dynamics

### The "Old Austin" vs "New Austin" Tension
- Longtime residents feel culture loss
- Housing costs have displaced communities
- Gentrification is real issue
- East Austin particularly affected

### How to Navigate as Newcomer
- Don't lead with "I'm from California"
- Acknowledge you're part of change
- Support local businesses
- Learn the history
- Be humble about what you're joining

### The California Question
- High-profile migration from CA
- Some resentment exists
- Texas pride is real
- Assimilate rather than compare

---

## Politics

### Austin's Position
- Progressive city
- Texas is conservative state
- Capital creates interesting dynamics
- Local politics active

### Topics to Navigate Carefully
- Guns (legal, many own them)
- Abortion (state restricts, city doesn't enforce)
- Immigration (near border, complex)
- Energy (oil/gas industry important to state)

### Advice
- Austin is more open but still Texas
- Don't assume everyone agrees with you
- Listen before speaking on charged topics
- Texans are proud, respect that

---

## Sports

### UT Austin (Longhorns)
- THE sports focus
- Football especially: Saturday tradition
- "Hook 'em Horns" gesture
- Burnt orange everywhere

### Professional Teams
| Team | Sport | League |
|------|-------|--------|
| Austin FC | Soccer | MLS |
| Round Rock Express | Baseball | AAA |
| Austin Spurs | Basketball | G-League |
| (No NFL, NBA, MLB) | — | — |

### Sports Culture
- UT football is religion
- Austin FC has grown fan base
- High school football serious
- Outdoor sports > watching sports

---

## Cultural Events

### Annual Events
- SXSW (March): Tech, music, film
- Austin City Limits (October): Music festival
- Eeyore's Birthday (April): Hippie gathering
- Bat Fest (August): Celebrate the bats
- Trail of Lights (December): Holiday lights

### Ongoing
- Live music every night
- Art walks
- Farmers markets
- Food truck events

---

## Etiquette Quick Guide

### Do
- Say "y'all"
- Hold doors
- Make small talk
- Tip generously
- Support local
- Respect the heat
- Embrace breakfast tacos

### Don't
- Honk unnecessarily
- Rush everything
- Talk badly about Texas
- Lead with where you're from
- Assume Austin is California 2.0
- Skip the BBQ experience
- Underestimate the outdoors culture
