# Weather & Climate — Austin

## Overview

**Humid subtropical climate** with hot summers and mild winters. The joke: Texas has two seasons — hot and less hot.

### Quick Stats
- **Average annual temp**: 68F (20C)
- **Annual rainfall**: 34 inches
- **Sunny days**: 228/year
- **Snow**: Rare (1-2 days/year if any)

---

## Monthly Breakdown

| Month | High/Low (F) | High/Low (C) | Rain | Notes |
|-------|--------------|--------------|------|-------|
| Jan | 62/41 | 17/5 | 2.5" | Mild, occasional cold fronts |
| Feb | 66/45 | 19/7 | 2.0" | Cedar fever peaks |
| Mar | 73/51 | 23/11 | 2.5" | Spring begins, wildflowers |
| Apr | 80/59 | 27/15 | 2.5" | Perfect weather |
| May | 86/66 | 30/19 | 4.5" | Warming up, storms possible |
| Jun | 92/72 | 33/22 | 3.5" | Summer begins |
| Jul | 96/74 | 36/23 | 2.0" | Peak heat |
| Aug | 97/74 | 36/23 | 2.5" | Hottest month |
| Sep | 90/69 | 32/21 | 3.5" | Still hot, storms |
| Oct | 81/59 | 27/15 | 4.0" | Relief begins |
| Nov | 71/49 | 22/9 | 3.0" | Beautiful fall |
| Dec | 63/42 | 17/6 | 2.5" | Mild winter |

---

## The Seasons

### Spring (March-May)
**Best time to visit**
- Bluebonnets bloom (March-April)
- Perfect temperatures (70-85F)
- Occasional thunderstorms
- SXSW crowds (mid-March)
- Outdoor activities ideal

**What to pack**: Layers, light jacket, rain layer

### Summer (June-September)
**Brutal heat**
- 95-105F daily highs
- 100F+ common in Aug
- High humidity makes it worse
- UV index extreme
- Outdoor activity before 10am or after 7pm

**Survival tips**:
- Stay hydrated (seriously)
- AC everywhere
- Pool/Barton Springs essential
- Embrace indoor activities
- Early morning or evening for outdoors

**What to pack**: Sunscreen, hat, light breathable clothes, water bottle

### Fall (October-November)
**Second best season**
- Relief from heat
- ACL Festival (Oct)
- Beautiful clear days
- Outdoor activities return
- Allergies can spike (ragweed)

**What to pack**: Light layers, sun protection still needed

### Winter (December-February)
**Mild but variable**
- Average 40-65F
- Occasional cold fronts (30s)
- Rare ice storms
- Cedar fever (Dec-Feb) — brutal allergies
- Shortest days but still sunny

**What to pack**: Light jacket, sweater, maybe one warm layer

---

## Weather Events

### Heat Waves
- Multiple 100F+ days in a row
- Usually July-August
- Take seriously — people die from heat
- Check on elderly neighbors
- Never leave pets/kids in cars

### Flash Floods
**Austin is in "Flash Flood Alley"**
- Most flood-prone area in North America
- Floods develop in minutes
- Low water crossings deadly
- May, June, October highest risk

**Rules**:
- Turn Around, Don't Drown
- 6 inches of water can sweep a car
- Never cross flooded roads
- Stay out of creeks during rain

### Severe Storms
- Spring thunderstorms (March-June)
- Large hail possible
- Tornadoes rare but possible
- Lightning common

### Ice Storms
- Rare (every few years)
- City shuts down (no infrastructure for it)
- Overpasses freeze first
- 2021 Winter Storm Uri was catastrophic (not normal)

---

## Allergies

### Cedar Fever (December-February)
**Austin's infamous allergy season**
- Mountain cedar (Ashe juniper) pollen
- Affects 1 in 4 residents
- Symptoms: Fatigue, congestion, headache
- Called "cedar fever" but it's allergies

**Solutions**:
- Get tested before moving
- Allergy meds (Zyrtec, Claritin)
- Air purifiers
- Monitor pollen counts
- Consider allergy shots

### Oak Pollen (March-April)
- Second worst season
- Yellow pollen covers everything
- Cars, patios, everything green-yellow
- Similar mitigation strategies

### Ragweed (Fall)
- September-November
- Less severe than cedar
- Still significant for sufferers

### Year-Round
- Mold spores (humidity)
- Grass pollen (spring-fall)
- Dust

### Resources
- KVUE allergy index
- pollen.com
- Allergist appointment recommended

---

## What to Expect Each Season

### Best Months to Visit
1. **October** — Perfect weather, ACL atmosphere
2. **April** — Bluebonnets, ideal temps
3. **November** — Beautiful fall
4. **March** — Great weather (avoid SXSW week if not attending)

### Months to Consider Avoiding
1. **August** — Brutally hot
2. **July** — Very hot
3. **February** — Cedar fever peak
4. **SXSW week** — If not attending

---

## Outdoor Activity Planning

### Summer Strategy
| Time | Activity |
|------|----------|
| 6-9am | Running, biking, hiking |
| 9am-6pm | Indoor activities, pools |
| 6-9pm | Outdoor dining, walks |
| 9pm+ | Night events, patios |

### Year-Round
| Activity | Best Months |
|----------|-------------|
| Hiking | Oct-Nov, Mar-Apr |
| Swimming | May-Sep |
| Biking | Mar-May, Oct-Nov |
| Live music outdoors | Mar-May, Sep-Nov |
| Golf | Year-round (avoid midday summer) |

---

## Water Considerations

### Drought
- Common, especially summer
- Water restrictions often in effect
- Lake Travis levels fluctuate dramatically
- Landscaping restrictions

### Lake Levels
- Highland Lakes system (Travis, Austin)
- Can drop significantly in drought
- Affects boating, swimming
- Check levels before lake activities

---

## Climate Change Impact

### Observed Trends
- Longer, hotter summers
- More extreme heat days
- Flash flood events increasing
- Drought periods intensifying
- Cedar season possibly lengthening

### Future Projections
- More 100F+ days per year
- Increased cooling costs
- Water supply pressure
- Austin's climate becoming more extreme

---

## Practical Tips

### Newcomer Survival Kit
- [ ] Sunscreen (use daily, year-round)
- [ ] Water bottle (carry always)
- [ ] Allergy meds (start before symptoms)
- [ ] Rain jacket (flash storms)
- [ ] Light layers (AC is aggressive)
- [ ] Hat and sunglasses
- [ ] Weather app with alerts

### Home Prep
- AC maintenance before summer (critical)
- Ceiling fans help significantly
- Know your breaker box (power outages)
- Blackout curtains reduce cooling costs
- Air purifier for allergies

### Vehicle Prep
- Sunshade essential
- Check tire pressure (heat affects it)
- Keep water in car
- Never leave living things in car
