# Business Setup — Austin

## Texas Business Environment

Texas is **business-friendly** — low regulation, no state income tax, straightforward formation. Austin adds creative energy and tech ecosystem.

### Why Austin for Business
- No state income tax (personal or corporate)
- Relatively low regulation
- Growing talent pool
- Tech ecosystem support
- Quality of life attracts employees
- Central US location

---

## Business Structures

### LLC (Most Common)
**Best for:** Most small businesses, startups, freelancers

**Pros:**
- Personal liability protection
- Pass-through taxation
- Flexible management
- Easy to set up

**Formation:**
- File Certificate of Formation with Texas SOS
- $300 filing fee
- No publication requirement
- Annual franchise tax (see below)

### Corporation (C-Corp or S-Corp)
**Best for:** Companies seeking VC funding, larger operations

**C-Corp:**
- Separate tax entity
- Can issue stock
- Required for VC investment
- Double taxation (corp + personal)

**S-Corp:**
- Pass-through taxation
- Limited to 100 shareholders
- Must be US citizens/residents
- Good for profitable small businesses

### Sole Proprietorship
**Best for:** Testing an idea, very small operations

- No formal registration required
- DBA if using different name
- No liability protection
- Simple but risky

---

## Formation Steps (LLC)

### 1. Choose a Name
- Must be distinguishable from existing TX entities
- Check: sos.state.tx.us
- Must include "LLC" or "Limited Liability Company"

### 2. Choose a Registered Agent
- Must have Texas address
- Can be yourself or service
- Receives legal documents
- Services: ~$50-150/year

### 3. File Certificate of Formation
- Online at SOS Direct: sos.state.tx.us
- Cost: $300
- Processing: 2-5 business days
- Expedite available (~$25 for same-day)

### 4. Create Operating Agreement
- Not filed but important
- Defines ownership and operations
- Required by most banks
- Template available online or use lawyer

### 5. Get EIN (Federal Tax ID)
- Free from IRS: irs.gov
- Required for bank accounts, hiring
- Instant online

### 6. Open Bank Account
- Need EIN, formation docs, operating agreement
- Many banks compete for business accounts
- Chase, Wells Fargo, local banks

---

## Taxes

### Franchise Tax
**Texas's version of corporate tax**

- Based on margin or revenue
- Threshold: $2.47 million revenue (2026)
- Below threshold: No tax owed (but still file)
- Rate: 0.375% - 0.75% depending on type

### No State Income Tax
- Applies to individuals AND businesses
- Pass-through entities (LLC, S-Corp) not taxed at entity level
- Just federal taxes on your personal return

### Sales Tax
- 8.25% in Austin (state + local)
- Physical products generally taxable
- Services often exempt
- SaaS: Complex, consult accountant

### Payroll Taxes
- Standard federal requirements
- Texas Workforce Commission (unemployment)
- Workers' comp: Required for most employers

---

## Freelancing / Self-Employment

### As a Freelancer
- Can operate as sole prop or LLC
- LLC recommended for liability protection
- Estimated quarterly taxes (federal)
- Track expenses for deductions

### Common Expenses (Deductible)
- Home office
- Equipment
- Software subscriptions
- Health insurance (self-employed)
- Professional development
- Travel for business

### Health Insurance
- Major consideration (no employer coverage)
- Healthcare.gov marketplace
- Health sharing ministries
- COBRA if leaving employer

### Retirement
- SEP IRA (up to 25% of income)
- Solo 401(k) (higher limits)
- Traditional/Roth IRA
- Plan for this — no employer match

---

## Office Space

### Options
| Type | Cost/Month | Best For |
|------|------------|----------|
| Home office | Free | Solopreneurs, remote |
| Co-working hot desk | $200-400 | Freelancers, small teams |
| Co-working dedicated | $400-800 | Growing teams |
| Private office | $800-2,000 | Established teams |
| Traditional lease | $25-50/sqft/year | Larger companies |

### Co-working Spaces
- **Capital Factory** — Startup hub, events
- **WeWork** — Multiple locations
- **Industrious** — Professional vibe
- **Link Coworking** — Local, community
- **Galvanize** — Tech-focused

### Traditional Office
- Class A: $40-60/sqft/year
- Class B: $25-40/sqft/year
- Typically 3-5 year leases
- Downtown most expensive
- Domain/North Austin growing

---

## Hiring

### Employment Basics
- At-will employment state
- No state minimum above federal ($7.25)
- Most Austin employers pay well above minimum
- Non-competes enforceable (with limits)

### Finding Talent
- Indeed (they're based here)
- LinkedIn
- UT Austin career services
- Tech meetups and events
- Referrals

### Employee vs Contractor
- IRS rules apply (behavioral, financial, relationship)
- Texas follows federal guidelines
- Misclassification risky
- Consult employment lawyer if unsure

### Benefits Expectations (Tech)
- Health insurance (company pays 70-100%)
- 401(k) with match
- Unlimited PTO (or generous PTO)
- Remote/hybrid flexibility
- Equity (startups)

---

## Legal Considerations

### Contracts
- Get an attorney for major contracts
- Templates okay for simple agreements
- Austin has good tech-focused lawyers

### Intellectual Property
- Federal (USPTO for patents/trademarks)
- Copyright automatic but register for enforcement
- Trade secrets: Use NDAs

### Business Licenses
- City of Austin business license (some categories)
- Check: austintexas.gov/businesses
- Industry-specific licensing varies
- Most tech companies minimal licensing

---

## Banking & Finance

### Business Banking
| Bank | Notes |
|------|-------|
| Chase | Large network, tech-friendly |
| Bank of America | Good integration |
| Mercury | Tech startup focused |
| Brex | Startup credit cards |
| Silicon Valley Bank | Traditional startup bank |
| Frost Bank | Texas regional |

### Business Credit
- Start with business credit card
- Build credit history
- SBA loans available
- Lines of credit for growth

---

## Resources

### Organizations
- **Austin Chamber of Commerce** — General business
- **Capital Factory** — Startup ecosystem
- **Techstars Austin** — Accelerator
- **Austin Technology Council** — Tech business

### Government Resources
- **Texas Comptroller** — Tax information
- **Texas Workforce Commission** — Employment
- **City of Austin Economic Development** — Local incentives

### Professional Services
- Attorneys: Wilson Sonsini, DLA Piper (tech)
- Accountants: Many tech-focused CPAs
- Bookkeeping: Pilot, Bench, local options

---

## Austin-Specific Tips

### Networking
- Attend events (SXSW, meetups)
- Capital Factory membership valuable
- Austin startup community is connected
- People are generally helpful

### Culture
- Less formal than NYC/SF
- Meetings at coffee shops normal
- Work-life balance valued
- Outdoor meetings common

### Timing
- Tech hiring cyclical
- SXSW brings visitors (network)
- Summer slower
- Q1 planning important
