---
name: AURA Security Scanner
description: Scan AI agent skills for malware, credential theft, prompt injection, and dangerous permissions before installing them
version: 1.0.0
requires:
  bins: []
  env: [AURA_API_URL]
  config: []
permissions:
  filesystem: []
  network: [api.aurasecurity.io]
  exec: []
tags: [security, malware-detection, skill-scanner, trust]
---

# AURA Security Scanner

Protect your AI agent from malicious skills. Scan any OpenClaw, Claude MCP, or LangChain skill before installation.

## What It Detects

- **Malware Patterns** - Credential theft, file exfiltration, crypto miners, backdoors
- **Prompt Injection** - Attempts to override system instructions or jailbreak agents
- **Permission Issues** - Overly broad filesystem, network, or execution permissions
- **Suspicious Networks** - Connections to known exfiltration domains (webhook.site, etc.)
- **Obfuscated Code** - Base64/hex encoded execution, dynamic eval patterns

## Usage

Ask me to scan a skill before you install it:

```
"Scan this skill for security issues: https://github.com/user/cool-skill"
```

```
"Is this skill safe? https://github.com/example/mcp-tool"
```

```
"Check https://clawhub.xyz/skill/weather-api for malware"
```

## Verdicts

| Verdict | Risk Score | Meaning |
|---------|-----------|---------|
| SAFE | 0-20 | No issues found, safe to install |
| WARNING | 21-50 | Minor concerns, review before installing |
| DANGEROUS | 51-80 | Significant risks detected, avoid |
| BLOCKED | 81-100 | Critical threats, do not install |

## AURA Verified Badge

Skills with a SAFE verdict can display the AURA Verified badge, showing users they've been scanned and approved.

## Examples

### Safe Skill Response
```
AURA Skill Scan: weather-api

Verdict: SAFE
Risk Score: 5/100
AURA Verified: Yes

Summary: Clean skill with minimal permissions.
Requests only weather API access.

Recommendation: Safe to install.
```

### Dangerous Skill Response
```
AURA Skill Scan: suspicious-helper

Verdict: DANGEROUS
Risk Score: 78/100
AURA Verified: No

Findings:
- CRITICAL: Accesses SSH keys (~/.ssh/id_rsa)
- HIGH: Sends data to webhook.site
- HIGH: Runs eval() on decoded base64

Recommendation: Do not install. Contains credential
theft and data exfiltration patterns.
```

## API

This skill calls the AURA Security API:

```
POST https://api.aurasecurity.io/scan-skill
{
  "skillUrl": "https://github.com/user/skill",
  "format": "auto",
  "includeRepoTrust": true
}
```

## About AURA

AURA (Agent Universal Reputation & Assurance) provides security infrastructure for the AI agent ecosystem. We verify skills, track agent reputation, and protect users from malicious code.

- Website: https://aurasecurity.io
- GitHub: https://github.com/aurasecurityio/aura-security
- X/Twitter: @aurasecurityio
