# Audos Agent Skill

Give any AI agent the power to build real businesses. User describes an idea → Audos deploys a full startup in ~10 minutes: landing page, brand identity, hero video, custom AI tools, CRM, analytics, and Otto — an AI co-founder who stays to help run the business.

🔗 **[GitHub](https://github.com/prehype/audos-agent-skill)** · **[Live Demo (SkiFit AI)](https://audos.com/site/103877)** · **[audos.com](https://audos.com)**

## Quick Start

```bash
# 1. Install the skill
clawhub install audos

# 2. Tell your agent:
"I want to build an AI fitness coaching app for ski season prep"

# 3. That's it — Audos handles the rest in ~10 minutes
```

## What It Does

A team of specialized AI agents work in parallel to build everything from scratch:

**The Build (~10 minutes):**
- **Brand Identity** — logo, colors, typography tailored to your audience
- **Hero Video** — branded intro video for your landing page
- **Landing Page** — conversion-optimized, live immediately with email capture
- **Workspace OS** — a full desktop-style command center

**What's in the Workspace:**
- **Otto** — an AI co-founder who knows your business plan, customers, and brand. Helps with strategy, content, ads, outreach, and daily operations
- **CRM & Contacts** — track every lead, deal pipeline, relationship history
- **Ad Campaign Manager** — create and run Facebook/Instagram ads with AI-generated creatives. $50 ad credit included to start acquiring customers
- **Cold Outreach Tools** — find prospects, send personalized messages at scale
- **Analytics Dashboard** — full-funnel tracking, attribution, conversion rates
- **Custom Mini-Apps** — vibe code interactive tools for your customers: ROI calculators, fitness assessments, quiz funnels, booking flows, onboarding wizards, pricing configurators — describe it in plain English, Otto builds it
- **Newsletter Builder** — branded emails to your contact list
- **Video Ad Creator** — animated social media ads
- **Stripe Integration** — accept payments from day one

No templates. No code. No complexity. Just momentum.

## Install (OpenClaw / ClawHub)

```bash
clawhub install audos
```

## Files

- `SKILL.md` — Full API v1.2 docs for the agent
- `scripts/audos.sh` — Shell helper for API calls
- `scripts/poll-with-updates.sh` — Build polling with progress narration
- `IMPROVEMENTS.md` — Roadmap and ideas

## API

Base URL: `https://audos.com/api/agent/onboard`

See `SKILL.md` for full API reference including auth, endpoints, error codes, and UX guidelines.

## Audos Publishing House

The record label for entrepreneurs. Audos doesn't take equity — it signs publishing deals:

- **30 days free** — full platform access, no credit card
- **$100/mo subscription** — keep 100% of revenue
- **Publishing deal** — up to $100K in value (cash advance + ad budget + production), 15% royalty post-recoup, you keep 85%

You own your brand, domain, customers, and IP. You can leave anytime.

[Learn more →](https://audos.com/publishing)

## Built by

[Audos](https://audos.com) — a [Prehype](https://prehype.com) venture.

## License

MIT
