---
name: attendance-sheet
description: Generate professional attendance sheets in xlsx format from employee work information. Perfect for HR, team management, and daily attendance tracking.
version: 1.0.0
---

# Attendance Sheet Generator

## Overview

Generate professional attendance sheets (考勤表) in xlsx format based on employee work information. Input employee names, dates, and attendance status (normal, late, absent, leave, etc.) to automatically create formatted Excel files ready for HR or management use.

## When to Use

Use this skill when:
- Creating monthly attendance reports
- Generating employee attendance sheets
- Converting raw attendance data to formatted Excel
- HR needs standardized attendance documentation

## Input Format

Provide the following information:

```
员工: 张三, 李四, 王五
日期范围: 2024-01-01 至 2024-01-31
考勤类型: 正常出勤, 迟到, 早退, 缺勤, 请假, 加班
```

Or structured format:
```json
{
  "employees": ["张三", "李四", "王五"],
  "start_date": "2024-01-01",
  "end_date": "2024-01-31",
  "attendance_types": ["正常出勤", "迟到", "早退", "缺勤", "请假", "加班"]
}
```

## Output

Generates an xlsx file with:
- Employee names in rows
- Dates in columns
- Attendance status cells with color coding
- Summary statistics (total days, late count, etc.)
- Professional formatting

## Usage Examples

**Example 1 - Monthly Report:**
```
Input: 员工列表 + 1月考勤数据
Output: 2024年1月考勤表.xlsx
```

**Example 2 - Simple Attendance:**
```
Input: 今天出勤人员: 张三, 李四
Output: 出勤记录_20240101.xlsx
```

**Example 3 - Full Month with Multiple Types:**
```
Input: 全体员工12月考勤数据（含迟到、请假）
Output: 2024年12月考勤统计表.xlsx
```

## Resources

### scripts/
- `generate_attendance.py` - Main Python script for generating attendance sheets
