---
name: atris
description: Codebase intelligence — generates structured navigation maps with file:line references so agents stop re-scanning the same files every session. Use when exploring code, answering "where is X?", or onboarding to a new codebase.
version: 1.0.0
requires:
  bins:
    - rg
tags:
  - developer-tools
  - codebase-navigation
  - token-optimization
  - code-map
  - context-management
---

# Atris — Codebase Intelligence

Maintain a structured map of the codebase with exact file:line references. One scan, permanent knowledge. Saves 80-95% of tokens on code exploration.

## Scope

- Use in any repo where you need to navigate code.
- Creates `atris/MAP.md` as the single navigation index.

## MAP-first rule

Before searching for anything in the codebase:

1. Read `atris/MAP.md`
2. Found your keyword → go directly to file:line. Done.
3. Not found → search once with `rg`, then **add the result to MAP.md**

The map gets smarter every time you use it. Never let a discovery go unrecorded.

## First time setup

If `atris/MAP.md` doesn't exist, generate it:

1. Create `atris/` folder in the project root
2. Scan the codebase (rules below)
3. Write the result to `atris/MAP.md`
4. Tell the user: "Built your codebase map at atris/MAP.md."

If `atris/MAP.md` already exists, use it. Regenerate only if the user requests it or the map is clearly stale (references missing files, line numbers way off).

## How to scan

Skip: `node_modules`, `.git`, `dist`, `build`, `vendor`, `__pycache__`, `.venv`, `.env*`, `*.key`, `*.pem`, `credentials*`, `secrets*`

Use ripgrep to extract structure:

```bash
# Key definitions
rg "^(export|function|class|const|def |async def |router\.|app\.|@app\.)" --line-number -g "!node_modules" -g "!.git" -g "!dist" -g "!.env*"

# Route definitions
rg "(get|post|put|delete|patch)\s*\(" --line-number -g "*.ts" -g "*.js" -g "*.py"

# Entry points
rg "listen|createServer|app\.start|if __name__" --line-number
```

## MAP.md structure

```markdown
# MAP.md — [Project Name] Navigation Guide

> Generated by Atris | Last updated: YYYY-MM-DD

## Quick Reference

rg "functionName" path/to/file.ext    # Description (line N)
rg "className" path/to/file.ext       # Description (line N)
```

Extract the top 15-25 most important symbols: entry points, exports, route handlers, main classes, config loaders.

### By-Feature Map

Group code by what it does. Every reference includes exact file path and line numbers.

```markdown
### Feature: User Authentication
**Purpose:** Login, registration, token management
- **Entry:** `src/auth/login.ts:45-89` (handleLogin)
- **Validation:** `src/auth/validate.ts:12-67` (validateToken)
- **Model:** `src/models/user.ts:8-34` (User schema)
- **Routes:** `src/routes/auth.ts:5-28` (POST /login, POST /register)
```

### By-Concern Map

Group by cross-cutting patterns (error handling, logging, auth middleware, etc).

### Critical Files

Flag high-impact files with why they matter and key functions with line numbers.

### Entry Points

How execution flows — dev server startup, request lifecycle, build pipeline.

## Keeping it fresh

Update MAP.md surgically when the codebase changes:

- **New file** → add to relevant section
- **Moved/renamed** → update all references
- **New important function** → add to Quick Reference
- **Deleted file** → remove from map
- **Major refactor** → regenerate affected sections

Small updates, not full regeneration. The map evolves with the code.

## Anti-patterns

- Searching without checking MAP first
- Letting discoveries go unrecorded
- Regenerating the full map when a surgical update would do
- Including secrets, credentials, or .env files in the map
- Guessing file locations instead of using the index
