---
name: astock-research
description: A股深度投研分析框架，参考同花顺/萝卜投研体系，包含基本面（宏观+微观）、资金面、技术面、情绪面、消息面五大维度。用于深度分析A股上市公司，制定交易预案。
---

# A股深度投研分析

参考同花顺、萝卜投研体系的专业投研框架。

## 核心工作流程

### 分析流程（五维一体）

```
基本面（宏观+微观）→ 资金面 → 技术面 → 情绪面 → 消息面 → 预案 → 结论
```

---

## 一、基本面分析（宏观+微观）

### 1.1 宏观层面（市场环境）

参考同花顺宏观数据模块：

| 分析维度 | 具体指标 | 数据来源 |
|---------|---------|---------|
| **大盘走势** | 上证指数、深证成指、创业板指 | ths_ifind.real_time_quotation.v1 |
| **经济数据** | GDP、CPI、PPI、PMI、社融、M2 | jin10宏观 |
| **政策环境** | 货币政策、财政政策、产业政策 | jin10快讯 |
| **全球联动** | 美股、港股、外汇、黄金 | QVeris |

**宏观分析框架：**
- 宏观经济周期（复苏/繁荣/衰退/萧条）
- 货币政策取向（宽松/收紧）
- 政策导向（扶持/调控）
- 风险因素（地缘、汇率、债务）

### 1.2 微观层面（公司质地）

参考同花顺F10和萝卜投研：

| 分析维度 | 具体指标 | 数据来源 |
|---------|---------|---------|
| **公司概况** | 主营业务、行业地位、概念题材 | ths_ifind.company_basics.v1 |
| **财务数据** | 营收、净利润、增速、毛利率、净利率 | ths_ifind.financial_statements.v1 |
| **估值水平** | PE、PB、PEG、股息率 | ths_ifind.company_basics.v1 |
| **盈利能力** | ROE、ROA、毛利率、净利率 | ths_ifind.income_statement.v1 |
| **成长能力** | 营收增速、利润增速 | ths_ifind.income_statement.v1 |
| **偿债能力** | 资产负债率、流动比率 | ths_ifind.balance_sheet.v1 |
| **运营能力** | 存货周转、应收账款周转 | ths_ifind.cash_flow_statement.v1 |

**微观分析框架：**
- **商业模式**：做什么、怎么赚钱、壁垒在哪
- **竞争格局**：行业地位、竞争对手、护城河
- **成长逻辑**：业绩增长的驱动因素
- **估值合理性**：贵了还是便宜

---

## 二、资金面分析

### 2.1 资金流向

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **主力资金** | latestVolume、amount | 判断资金进出 |
| **量比** | vol_ratio | 放量/缩量程度 |
| **换手率** | turnoverRatio | 活跃度 |
| **成交额** | amount | 市场关注度 |

### 2.2 股东结构

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **机构持仓** | 机构持股比例 | 主力看好程度 |
| **股东户数** | 股东户数变化 | 筹码集中/分散 |
| **解禁情况** | 限售股解禁 | 抛压风险 |

### 2.3 估值流动性

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **市值** | mv | 大盘/中盘/小盘 |
| **流通市值** | freeFloat | 流动性 |
| **PE-TTM** | pe_ttm | 估值水平 |
| **PB** | pb | 估值水平 |

---

## 三、技术面分析

### 3.1 趋势判断

| 分析维度 | 具体指标 | 数据来源 |
|---------|---------|---------|
| **日线走势** | 收盘价、最高、最低 | ths_ifind.history_quotation.v1 |
| **均线系统** | 5/10/20/60日均线 | 计算得出 |
| **趋势方向** | 上涨/下跌/震荡 | 形态判断 |

### 3.2 支撑压力

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **支撑位** | 前期低点、均线 | 买入参考 |
| **压力位** | 前期高点、均线 | 卖出参考 |
| **缺口** | 向上/向下跳空 | 趋势强度 |

### 3.3 K线形态

| 形态类型 | 具体形态 | 信号意义 |
|---------|---------|---------|
| **反转形态** | 锤子线、吞没、乌云盖顶 | 趋势可能逆转 |
| **持续形态** | 三角形、旗形、楔形 | 蓄势待发 |
| **突破形态** | 放量长阳/长阴 | 趋势加速 |

### 3.4 技术指标

| 指标 | 参数 | 信号 |
|-----|------|------|
| **MACD** | 12,26,9 | 金叉/死叉、背离 |
| **RSI** | 6,12,24 | 超买(>70)/超卖(<30) |
| **KDJ** | 9,3,3 | 超买/超卖 |

### 3.5 缠论视角（可选）

- 笔、线段划分
- 中枢构建
- 背驰判断
- 买卖点定位

---

## 四、情绪面分析

### 4.1 市场情绪

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **涨跌停** | 涨停/跌停家数 | 市场热度 |
| **板块轮动** | 领涨/领跌板块 | 资金偏好 |
| **龙头股** | 龙头股走势 | 市场风向标 |

### 4.2 个股情绪

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **换手率** | turnoverRatio | 筹码交换 |
| **量价配合** | 放量上涨/缩量下跌 | 趋势健康度 |
| **股性** | 历史波动特征 | 活跃度 |

### 4.3 机构情绪

| 分析维度 | 具体指标 | 解读 |
|---------|---------|------|
| **研报评级** | 买入/增持/中性/减持 | 机构态度 |
| **目标价** | 目标价 vs 当前价 | 上涨空间 |
| **业绩预期** | 业绩预测 | 增长信心 |

---

## 五、消息面分析

### 5.1 业绩公告

| 事件类型 | 时间节点 | 影响 |
|---------|---------|------|
| **业绩预告** | 1月底、7月底 | 业绩预期 |
| **正式财报** | 4月底、8月底 | 业绩确认 |
| **业绩修正** | 预告后 | 业绩下调/上调 |

### 5.2 资本运作

| 事件类型 | 具体事项 | 影响 |
|---------|---------|------|
| **定增/配股** | 融资需求 | 稀释股权 |
| **减持/增持** | 大股东行为 | 信心信号 |
| **回购/激励** | 管理层动作 | 积极信号 |
| **并购重组** | 外延发展 | 预期改变 |

### 5.3 行业动态

| 事件类型 | 具体事项 | 影响 |
|---------|---------|------|
| **政策出台** | 补贴、监管、规划 | 行业走向 |
| **供需变化** | 产能、需求 | 景气度 |
| **价格波动** | 原料、产品价格 | 利润影响 |

### 5.4 重大事项

| 事件类型 | 具体事项 | 影响 |
|---------|---------|------|
| **诉讼仲裁** | 法律风险 | 不确定性 |
| **监管问询** | 函件关注 | 诚信疑问 |
| **高管变动** | 辞职、任命 | 经营预期 |
| **突发事件** | 安全事故、舆情 | 黑天鹅 |

---

## 六、全场景预案

### 剧本A - 上涨突破
- **触发条件**: 放量突破压力位
- **目标位**: 目标价计算（PE法/PEG法）
- **止损位**: 跌破支撑

### 剧本B - 下跌破位
- **触发条件**: 放量跌破支撑位
- **目标位**: 前期低点/技术支撑
- **止损位**: 反弹突破

### 剧本C - 震荡整理
- **震荡区间**: 支撑-压力之间
- **策略**: 高抛低吸

### 剧本D - 观望等待
- **触发条件**: 消息真空/趋势不明
- **关注**: 催化剂等待

---

## 七、结论

### 核心判断
1. **宏观环境**：当前市场交易什么逻辑？
2. **公司质地**：贵了还是便宜？
3. **走势判断**：上涨/下跌/震荡？

### 操作建议
- **评级**：买入/增持/中性/减持/观望
- **仓位**：建议仓位
- **价位**：建仓/加仓区间

### 风险提示
- 流动性风险
- 政策风险
- 业绩风险
- 系统性风险

---

## 数据获取速查

### 实时行情
```json
{
  "codes": "000001.SZ,600000.SH"
}
```

### 财务三表
```json
{
  "statement_type": "income_statement",
  "codes": "000001.SZ",
  "year": "2024",
  "period": "1231",
  "type": "1"
}
```

### 公司基本信息
```json
{
  "codes": "000001.SZ"
}
```

---

## 关键原则

1. **五维闭环** - 五个维度缺一不可，形成逻辑链
2. **数据说话** - 用数据验证观点，不要主观臆断
3. **动态跟踪** - 基本面变化及时更新判断
4. **风险第一** - 始终把风控放在首位
5. **知行合一** - 制定预案后要严格执行
