# 再平衡与动态管理协议

## 一、再平衡的本质与价值

再平衡（Rebalancing）是指将偏离目标比例的投资组合定期恢复至初始设定比例的操作。

**再平衡的价值**：
1. **控制风险**：阻止组合因市场涨跌而无意间提高风险等级
2. **强制低买高卖**：减持涨多的资产，买入跌多的资产（逆向操作）
3. **维持投资纪律**：系统化操作，减少情绪干扰

**示例**：
- 初始：股票50%，债券50%（平衡型）
- 股市大涨1年后：股票变成65%，债券变成35%
- 此时组合实际风险已超出设定，需再平衡 → 卖出15%股票，买入15%债券

---

## 二、再平衡触发规则

### 方法A：日历触发（Calendar Rebalancing）

| 风险等级 | 再平衡频率 | 执行时间建议 |
|---------|---------|-----------|
| 保守型 | 每年一次 | 每年1月初或12月末 |
| 稳健型 | 每年一次 | 同上 |
| 平衡型 | 每半年一次 | 每年1月 + 7月 |
| 积极型 | 每季度一次 | 每年1月/4月/7月/10月 |
| 激进型 | 每季度一次 | 同上 |

### 方法B：偏差触发（Threshold Rebalancing，推荐）

当任一资产实际比例偏离目标超过以下阈值时，无论时间如何都触发再平衡：

| 风险等级 | 触发阈值 |
|---------|---------|
| 保守/稳健型 | ±5个百分点 |
| 平衡型 | ±8个百分点 |
| 积极/激进型 | ±10个百分点 |

**示例**：平衡型目标权益50%，若权益实际达到58%（+8%），触发再平衡

### 方法C：组合使用（最优实践）

- 每季度检查偏差
- 若任意资产偏离超过阈值，立即再平衡
- 即使无偏差，每年至少执行一次全面检视

---

## 三、再平衡操作步骤

### Step 1：计算当前实际配置
```
实际比例 = 各类资产当前市值 ÷ 组合总市值 × 100%
```

### Step 2：与目标比例对比
```
偏差 = 实际比例 - 目标比例
正偏差 = 超配（需减持）
负偏差 = 低配（需补充）
```

### Step 3：计算调整金额
```
调整金额 = |偏差| × 组合总市值
```

### Step 4：执行调整
**优先方式**（减少交易成本）：
1. 新增资金优先投入低配资产（不需卖出）
2. 将分红/利息收入投入低配资产
3. 若需要，卖出超配资产买入低配资产

### Step 5：记录与归档
- 记录再平衡前后的配置比例
- 记录执行原因（日历触发/偏差触发）
- 记录交易成本

---

## 四、再平衡成本控制

### 降低交易成本
- 优先用新增现金补充低配，避免出售
- 不要过于频繁再平衡（每次都有交易成本）
- 场内ETF的买卖成本约0.025%，优于场外基金

### 税务考虑
- 中国目前基金差价暂不征个人所得税 ✓
- 再平衡带来的交易暂无特别税务负担 ✓
- 但储蓄国债提前赎回有手续费损失 ⚠️

---

## 五、年度全面复盘清单

每年至少一次，进行以下全面检视：

### 财务状况更新
- [ ] 当年净资产变化（增加/减少多少）
- [ ] 年收入/支出结构是否有变化
- [ ] 应急储备金是否仍然充足（3-6个月支出）
- [ ] 负债情况变化（房贷是否有提前还款机会）

### 投资组合表现
- [ ] 各类资产实际收益 vs 目标收益
- [ ] 最大回撤是否在承受范围内
- [ ] 各资产实际比例 vs 目标比例
- [ ] 持有基金的基金经理是否变更

### 人生阶段与目标
- [ ] 距离各目标（退休/子女教育/购房）的时间缩短了
- [ ] 目标金额是否需要上调（通货膨胀）
- [ ] 是否有新增目标
- [ ] 风险承受能力是否有变化（年龄增长、家庭变化）

### 宏观环境更新
- [ ] 经济周期是否发生变化
- [ ] 主要市场估值是否进入极端区间
- [ ] 是否有重大政策变化需要应对

---

## 六、触发全面重新规划的情形

以下任一情形发生时，需要制定全新IPS（不是简单再平衡）：

| 触发事件 | 原因 |
|---------|------|
| 结婚/离婚 | 财务状况、风险承受能力根本性变化 |
| 子女出生 | 新增教育金目标；支出结构变化 |
| 失业/创业 | 收入稳定性变化；流动性需求提升 |
| 继承大额遗产 | 可投资资产大幅增加，需升级规划 |
| 严重健康事件 | 流动性需求、遗产规划等新增考量 |
| 退休 | 从"积累阶段"进入"消耗阶段"，策略根本改变 |
| 资产增减>30% | 规模变化导致可进入的产品类型改变 |

---

## 七、从积累期到退休期的策略转换

### 积累期（Accumulation Phase）
- 目标：资产最大化增长
- 策略：高权益比例，容忍短期波动
- 特点：时间是最大资产，复利效果强

### 临近退休期（3-5年内）
- 目标：保护已积累成果
- 策略：逐年降低权益比例（每年降5%）
- 工具：增加债券、货币基金比例

**"滑道"策略（Glide Path）**：
```
距退休年数 → 权益比例
10年：60%
7年：50%
5年：40%
3年：30%
1年：20%
退休：15%-20%（维持对抗通胀的最低权益配置）
```

### 退休期（Distribution Phase）
- 目标：可持续地提取生活费用，同时维持资产不过快消耗
- 策略："4%法则"参考（每年提取不超过总资产4%）
- 配置：低波动组合（债券为主+少量权益+黄金）
- 特别考量：医疗费用储备；遗产规划
