# 专业产品筛选标准手册

## 核心原则：低成本 + 分散 + 长期持有

---

## 一、指数基金（ETF）— 核心配置首选

### 为何优先指数基金
- 学术研究（巴菲特赌局等）证明：长期看，90%主动基金跑不赢对应指数
- 费率极低（0.05%-0.5%/年），复利30年后费率差距达数百万
- 持仓透明，无"风格漂移"风险
- 无基金经理离职风险

### 宽基ETF推荐顺序（核心仓位）

**第一优先：沪深300**
- 代表中国300家最大上市公司
- 流动性最好，费率最低
- 适合：所有风险等级作为A股核心仓位

筛选标准：
- 规模 > 500亿（优先选最大规模的同类产品）
- 年管理费+托管费 ≤ 0.15%（最优）
- 近3年跟踪误差 < 0.3%
- 场内ETF优先（费率更低，实时交易）

**第二优先：中证500/中证A500**
- 代表中等市值公司，成长性更强
- 历史长期收益略高于沪深300，但波动更大

筛选标准：
- 规模 > 100亿
- 管理费+托管费 ≤ 0.2%/年

**第三优先：中证1000（激进型）**
- 小盘股指数，波动最大，长期成长潜力也最大
- 仅适合激进型，且仓位不超过总权益的30%

**创业板指/科创50**
- 科技成长方向，波动极大
- 适合积极/激进型投资者，不超过总权益的20%

**红利低波指数（稳健型额外选项）**
- 选取高股息、低波动的股票
- 适合稳健型作为"股债之间"的资产
- 特点：股息率高（3-6%），波动低于宽基

---

## 二、主动偏股基金 — 严格筛选，少量配置

### 配置原则
- 总组合中主动基金占比不超过权益部分的40%
- 余下权益全部用低费率ETF覆盖
- 原因：主动基金费率高（管理费1.5%+），长期收益不确定

### 严格筛选标准（必须全部满足）

| 筛选维度 | 最低要求 | 优秀标准 |
|---------|---------|---------|
| 成立时间 | >5年 | >8年 |
| 规模 | 10亿-300亿 | 30亿-150亿（黄金区间）|
| 近5年年化 | >12% | >15% |
| 近5年最大回撤 | <45% | <35% |
| 夏普比率(近3年) | >0.8 | >1.0 |
| 基金经理任职 | >3年（管理此基金）| >5年 |
| 申购费率 | <0.5% | 0.1%（折扣后）|
| 年管理费 | <1.5% | <1.2% |

### 如何查询夏普比率
- 天天基金App → 基金详情 → "风险指标"
- 晨星基金网站（Morningstar.cn）
- 理杏仁网站

### 主动基金选择策略
- 重点看：历史上熊市（2018年、2022年）跌幅是否明显小于同类
- 查看持仓：是否分散？是否经常大幅换仓？
- 关注：基金经理是否有明确投资哲学并坚持执行

---

## 三、债券基金 — 稳健底仓

### 纯债基金（最安全）
**适用**：保守/稳健型的债券底仓

筛选标准：
- 类型：短期纯债（持仓久期<2年）或中长期纯债
- 规模：>20亿
- 近3年最大回撤：短债<2%；中长债<5%
- 近3年年化收益：短债>3%；中长债>4%
- 申购费：<0.1%
- 管理费：<0.5%/年
- 关注：持仓是否包含低评级信用债（AA-以下需警惕）

**注意**：债基不是"保本"产品！利率上升时净值会下跌。

### 可转债基金（中等风险）
**适用**：平衡/积极型，兼顾股债

特点：
- 可转债价格<面值（100元）时：下行保护好（债性主导）
- 可转债价格>130元时：跟随正股涨跌（股性主导）
- 历史年化收益约7%-12%，最大回撤约15%-25%

筛选标准：
- 持仓分散（不集中在少数转债）
- 回避低评级（AA-以下）占比高的基金
- 规模：>10亿

### 偏债混合基金（固收+）
**适用**：稳健型作为"债券+"部分

特点：
- 股票仓位约20%-30%，其余为债券
- 目标：比纯债多1-3%收益，最大回撤控制在10%内

筛选标准：
- 近5年年化 > 6%
- 近5年最大回撤 < 12%
- 股债比例稳定（不频繁大幅调整）

---

## 四、QDII境外基金

### 美股QDII

**纳斯达克100联接基金**（首选）
- 追踪全球科技龙头，历史年化约15%（美元计价）
- 管理费：0.6%-0.85%/年（QDII管理费普遍较高）
- 风险：科技股集中度高，波动大；汇率风险

**标普500联接基金**
- 更分散，包含各行业龙头
- 历史年化约10%-12%（美元计价）
- 风险低于纳斯达克100

筛选要点：
- 确认"申购状态：开放"（QDII有外汇额度限制，可能暂停申购）
- 规模：>5亿（规模太小可能暂停）
- 对比同类产品的费率和跟踪误差

### 港股QDII/ETF
- 恒生科技ETF：追踪港股科技龙头（腾讯/阿里/美团等）
- 恒生指数ETF：追踪港股整体
- 注意：港股估值便宜，但受中美关系和政策影响大

---

## 五、黄金投资工具

### 黄金ETF（场内，首选）
- 直接跟踪伦敦金/上海金价格
- 费率：管理费约0.5%/年
- 流动性好，实时交易

### 黄金基金（场外联接）
- 操作如普通基金，无需证券账户
- 费率略高（申购费+管理费）

### 实物黄金（高净值补充）
- 工行/农行"积存金"：按克购买，灵活
- 投资金条：保值但变现较麻烦（需找回购机构）
- 不建议购买"工艺品"黄金（溢价极高）

### 黄金占组合比例建议
- 保守型：2%-5%
- 稳健型：5%-8%
- 平衡型：5%-10%
- 积极型：5%-10%
- 激进型：5%-15%（宏观对冲）

---

## 六、储蓄国债（保守型必选）

### 发行规律
- 每年3月至11月，每月10日左右
- 具体日期提前约1周公告
- 个人限购300万/期
- 额度极为有限，通常1-2小时售罄

### 抢购技巧
1. 关注工农中建等大行的公众号或App推送
2. 发行前夜确认银行余额充足
3. 发行当天9:00前登录网银App
4. 整点自动放额，立即操作

### 2025年参考利率（以实际公告为准）
- 3年期：约2.35%
- 5年期：约2.5%
- 利息免个人所得税（实际收益优于同期定期存款）

---

## 七、公募REITs（平衡/积极型补充）

### 什么是REITs
- 投资于实物资产（高速公路/仓储/保障房/数据中心）的基金
- 强制90%以上利润分红
- 场内ETF形式交易

### 筛选标准
- 底层资产质量：关注资产区位（一线城市>其他）
- 分红率：>4%（净现金分红/基金价格）
- 运营稳定性：底层资产出租率>90%

### 注意事项
- REITs分红需缴个人所得税（与股票一样）
- 适合长期持有（资产价值随时间增长）
- 流动性弱于股票ETF，买卖价差较大

---

## 八、私募基金（高净值专属，>100万门槛）

### 适用条件
- 可投资金融资产 > 500万
- 风险等级：积极型或激进型
- 投资经验 > 2年

### 类型
- **私募股票基金**：主观多头/量化策略，预期年化10%-20%+
- **量化中性基金**：市场中性策略，预期年化8%-15%，与市场相关性低
- **CTA（期货策略）**：趋势跟踪，在市场暴跌时往往盈利（对冲价值）

### 尽职调查要点
- 基金管理人需在中国证券基金业协会备案（可查询amac.org.cn）
- 历史业绩：要求完整3年以上实盘数据（非回测）
- 最大回撤：<20%（量化中性）/<35%（主观多头）
- 夏普比率：>1.0
- 锁定期：通常1年，确认流动性条款
- 警惕：承诺"保本"的私募（违法）；无备案的产品（非法）
