# 宏观分析框架参考手册

## 一、美林投资时钟详解

### 四个周期阶段识别指标

**复苏期（Recovery）**
- 特征：GDP增速回升，通胀仍低，失业率开始下降
- 货币政策：宽松或开始收紧
- 领先指标：PMI从荣枯线以下开始回升（<50→>50）
- 最优资产：权益资产（股票/偏股基金）
- 次优：债券（利率仍低，债券持仓价值仍高）

**过热期（Overheat）**
- 特征：GDP高速增长，通胀上升，就业充分
- 货币政策：持续加息
- 领先指标：CPI>3%，PPI持续高位，大宗商品价格暴涨
- 最优资产：商品/实物资产/高股息股票
- 次优：周期性权益

**滞胀期（Stagflation）**
- 特征：GDP增速下滑，通胀依然高企（最痛苦阶段）
- 货币政策：两难（既要降息刺激，又要加息抗通胀）
- 领先指标：GDP同比下滑，CPI仍高，企业盈利恶化
- 最优资产：现金/货币基金（无好资产）
- 次优：商品（通胀未退时仍有支撑）

**衰退期（Recession）**
- 特征：GDP收缩，通胀下降，失业率上升
- 货币政策：宽松（降息降准）
- 领先指标：PMI持续<50，M2增速下降，信贷收缩
- 最优资产：债券/黄金
- 次优：现金

---

## 二、中国特色宏观指标解读

### 核心数据来源

| 指标 | 数据来源 | 更新频率 | 解读意义 |
|------|---------|---------|---------|
| GDP增速 | 国家统计局 | 季度 | 经济整体方向 |
| CPI（消费价格指数）| 国家统计局 | 月度 | 通胀水平 |
| PPI（生产价格指数）| 国家统计局 | 月度 | 企业端通胀，CPI领先指标 |
| PMI（制造业）| 统计局/财新 | 月度 | 50以上扩张，50以下收缩 |
| M2增速 | 央行 | 月度 | 货币供应量，流动性宽松度 |
| 社会融资规模 | 央行 | 月度 | 信贷扩张，经济活力 |
| 10年期国债收益率 | 中债信息网 | 日度 | 利率水平，债市估值 |
| 人民币汇率（CNY/USD）| 中国外汇交易中心 | 日度 | 跨境资本流动 |

### 政策工具解读

**央行降息/降准 → 对资产的影响**：
- 债券：价格上涨（利率↓=债券价格↑）
- 权益：短期利好（降低融资成本）；中长期需看经济能否复苏
- 黄金：利好（实际利率下降）
- 人民币：贬值压力（汇率波动）

**房地产政策松绑 → 对资产的影响**：
- 周期类权益：利好（建材/家电/金融）
- REITs：不确定（商业地产vs居住地产差异大）

---

## 三、A股估值参考体系

### 沪深300历史PE分位（近20年数据）
- 历史最低：约8-9倍（2005年、2014年）
- 历史平均：约12-13倍
- 历史最高：约20-25倍（2007年、2015年）
- 当前合理区间：10-16倍视为"合理"

### 估值查询工具
- 中证指数官网：www.csindex.com.cn → 指数估值
- 理杏仁：www.lixinger.com（免费注册查PE历史分位）
- 天天基金App → 首页 → "市场" → "估值"

### 市场整体判断框架
```
股市估值分位 × 宏观周期 → 综合判断

低估（<30%分位）+ 复苏期 = 最强买入信号 ⭐⭐⭐⭐⭐
低估（<30%分位）+ 衰退期 = 强买入信号 ⭐⭐⭐⭐
合理（30-60%）+ 复苏期 = 正常配置 ⭐⭐⭐
合理（30-60%）+ 过热期 = 中性偏谨慎 ⭐⭐
高估（>75%分位）+ 任何周期 = 减仓信号 ⚠️
```

---

## 四、债券市场分析框架

### 利率与债券价格的关系
- 利率上升 → 债券价格下跌（持有中的债基净值下跌）
- 利率下降 → 债券价格上涨（持有中的债基净值上涨）

### 债券品种风险层级
1. **利率债**（最低风险）：国债、政策性金融债（无信用风险）
2. **城投债**（中等风险）：地方融资平台债券（关注区域财政）
3. **产业债**（中高风险）：企业信用债（关注评级和行业）
4. **可转债**（中高风险）：兼具股性和债性，波动较大

### 当前判断要点
- 关注10年国债收益率位置（低于2%说明债市已贵）
- 信用利差（信用债-国债）收窄 → 信用债性价比下降
- 如进入降息周期初期 → 利率债机会最大

---

## 五、黄金分析框架

### 黄金价格驱动因素（重要性排序）
1. **实际利率**（最重要）：美债实际收益率（10年TIPS）越低越利好黄金
2. **美元指数**：美元走弱，黄金通常走强（负相关）
3. **地缘政治风险**：战争/冲突/制裁等避险需求
4. **央行购金**：全球央行持续增持黄金（近年重要因素）
5. **通胀预期**：高通胀环境利好黄金保值需求

### 黄金的配置逻辑
- **对冲通胀**：长期持有黄金可保值
- **降低组合波动**：黄金与股票相关性低（-0.1至0.2）
- **极端风险对冲**：金融危机/战争时黄金往往暴涨
- **建议仓位**：任何组合配置5%-15%黄金ETF

---

## 六、美股/QDII分析框架

### 纳斯达克100适合配置的逻辑
- 包含苹果、微软、英伟达、谷歌等全球科技龙头
- AI革命长期受益板块
- 历史20年年化约15%（含汇率换算后约12-13%）

### 美股配置注意事项
- 汇率风险：人民币升值会侵蚀QDII收益（反之则增强）
- 中美关系：地缘政治风险
- 估值：标普500席勒PE历史均值约17，当前若>30需注意
- 额度：个人每年购汇限额5万美元（通过QDII基金无需占用额度）

### 港股分析
- 估值长期低于A股（历史"折价"约30%）
- 受美元利率影响大（港元与美元挂钩）
- 国内政策风险：监管政策对互联网/医疗等行业影响大
- 当前：恒生科技PE历史低位，但复苏需政策持续催化
