# 行为金融学偏差手册

## 投资者常见认知偏差识别与应对

行为金融学研究表明，投资者的决策往往受到非理性心理因素的影响，导致系统性错误。专业顾问的重要价值之一，就是帮助客户识别并克服这些偏差。

---

## 一、认知类偏差（Cognitive Biases）

### 1. 损失厌恶（Loss Aversion）
**表现**：对亏损的痛苦是同等收益快乐的2倍以上
**识别信号**：
- "我绝对不能亏钱，哪怕1分钱"
- 持有亏损资产不愿卖出（怕"确认"亏损）
- 刚刚盈利就立刻卖出（怕"吐出去"）

**对投资的伤害**：
- 持有应该止损的资产太久
- 太早卖出应继续持有的优质资产
- 错误地把"没有亏损"等同于"保值"

**应对方案**：
- 设定投资纪律前就明确止损线，并写下来
- 强调：未实现的亏损与已实现亏损对净资产影响完全一样
- 关注组合总收益，而非单只产品盈亏
- 使用"如果我现在是空仓，我会买入这只产品吗？"的思维实验

---

### 2. 近因偏差（Recency Bias）
**表现**：过度重视近期发生的事件，认为近期趋势会延续
**识别信号**：
- "XXX基金最近3个月涨了30%，我要买"
- "市场已经跌了半年了，感觉还会继续跌"
- 看到连续上涨就追买，连续下跌就恐慌卖出

**对投资的伤害**：
- 高位追买，低位割肉（典型的追涨杀跌）
- 错过均值回归机会
- 实际买入时机与最优时机相反

**应对方案**：
- 展示历史数据：市场下跌后的1年、3年回报往往更高
- 均值回归原则：高收益之后往往是平均，低收益之后往往是反弹
- 建立自动定投，消除主观择时冲动

---

### 3. 锚定效应（Anchoring Effect）
**表现**：过度依赖某个参考值（"锚"）做判断
**识别信号**：
- "我买入价是100元，不到100元不卖"
- "这只股票历史最高价是50元，现在30元算便宜了"
- "去年基金涨了20%，今年如果没有20%我就换一只"

**对投资的伤害**：
- 不合理的心理参考点导致错误的买卖决策
- 忽视当前市场基本面的真实价值

**应对方案**：
- 买入价是沉没成本，与未来涨跌无关
- 应关注当前估值是否合理，而非历史高低价
- 使用"这个资产在未来1年的期望回报是多少？"替代"跌了多少"

---

### 4. 过度自信（Overconfidence）
**表现**：高估自己选股/择时能力，低估投资风险
**识别信号**：
- "我研究过这家公司，肯定会涨"
- "我能感觉到市场要反弹了"
- 频繁交易，相信自己能找到Alpha

**对投资的伤害**：
- 过度集中持股（欠缺分散）
- 交易成本大幅侵蚀收益
- 实证：个人投资者平均年化收益比市场低4-6%

**应对方案**：
- 展示数据：90%以上主动基金长期跑不赢指数
- 建议：用ETF覆盖市场Beta，省下精力做其他事
- 如果一定要"选股"，限定仓位不超过总资产10%

---

### 5. 确认偏见（Confirmation Bias）
**表现**：主动寻找支持自己已有观点的信息，忽视反面证据
**识别信号**：
- 已经决定买了才来"研究"，研究过程只找利好
- 对批评自己持仓的观点一律忽视或反驳
- 只关注"成功"的投资案例，忽视失败案例

**应对方案**：
- 做投资决策前，主动寻找3条以上"不该买的理由"
- 找一个观点相反的专业人士的文章/报告认真阅读
- 记录决策日志，定期复盘判断是否正确

---

## 二、情绪类偏差（Emotional Biases）

### 6. 羊群效应（Herding）
**表现**：跟随大众行为，而非独立判断
**识别信号**：
- "我周围的人都在买，我也要买"
- "XX网红推荐了，应该没错"
- 市场疯狂时才加仓，崩溃时才赎回

**数据警示**：
- 基金公司销售数据：牛市顶部申购量是熊市底部的5-10倍
- 最大的申购量往往出现在最高点的前后

**应对方案**：
- 建立"反向指标"意识：大众狂热=警惕信号
- 定投计划强制在低点继续买入
- 设定"我的配置比例"，不受外界情绪影响

---

### 7. 心理账户（Mental Accounting）
**表现**：将资金分成"不同账户"，适用不同风险标准
**识别信号**：
- "这是奖金，可以拿来冒险，亏了无所谓"
- "这是孩子的教育金，绝对不能亏"
- "炒股亏的钱不算，反正是"玩玩""

**对投资的伤害**：
- 同样的钱因为"来源"不同而适用不同风险标准，不合理
- 可能导致某个"心理账户"承担了过高风险

**应对方案**：
- 所有金融资产统一纳入整体资产管理框架
- 机会成本是统一的：每一分钱都有同样的增值潜力
- 目标导向（Goal-Based）：按用途分类，而非按来源分类

---

### 8. 后悔厌恶（Regret Aversion）
**表现**：因为害怕后悔，而避免做决策或做出次优决策
**识别信号**：
- "万一买了跌了怎么办，不买了"（错过机会）
- 买了市场主流的基金，即使不是最优选择（怕别人看到自己"奇怪"）
- 卖掉之后涨了，无限自责

**应对方案**：
- 明确：不决策也是一种决策（持有现金=接受通胀侵蚀）
- 记录决策理由而非结果，用过程评价判断质量
- 接受：好的决策不一定带来好结果，坏的决策也可能带来好结果（短期）

---

## 三、行为防护实践建议

### 投资日志（强烈建议）
每次做出投资决策时，记录：
1. 买入/卖出的理由（3条以上）
2. 当时的市场情绪（乐观/中性/悲观）
3. 预期持有时间
4. 什么情况下我会改变这个决策？

### "10-10-10"冷静法则
在做出重要投资决策前，问自己：
- 10分钟后，我还会这样想吗？
- 10个月后，我会怎么评价这个决定？
- 10年后，这个决定重要吗？

### 顾问的角色
专业顾问的最大价值之一，就是在市场极端情绪时（无论恐慌还是狂热），帮助投资者保持理性，坚守投资纪律。
