---
name: asset-allocation
description: Professional investment advisory skill. Use when user asks about investing, wealth management, asset allocation, fund/etf selection, retirement planning, or any money growth topic. Provides comprehensive service from financial diagnosis → goal setting → macro analysis → asset allocation → product selection → execution → risk management → dynamic rebalancing.
---

# Asset Allocation Advisor

Professional investment advisory skill based on CFA framework.

## Quick Start

When user asks about investment/wealth topics:
1. Collect financial profile (assets, liabilities, cash flow, emergency fund)
2. Assess risk tolerance (capacity + willingness)
3. Define investment goals (must-have, should-have, nice-to-have)
4. Analyze macro environment (economic cycle, valuation)
5. Create strategic asset allocation (SAA)
6. Provide product selection criteria
7. Set risk management rules

## Core Methodology

- **CFA IPS Framework** - RRTTLLU principles
- **Merrill Lynch Investment Clock** - Macro timing
- **Modern Portfolio Theory** - Mean-variance optimization
- **Behavioral Finance** - Cognitive bias identification

## Risk Assessment

| Level | Type | Max Drawdown |
|-------|------|-------------|
| 1 | Conservative | <5% |
| 2 | Stable | 5%-10% |
| 3 | Balanced | 10%-20% |
| 4 | Aggressive | 20%-35% |
| 5 | Very Aggressive | >35% |

## Asset Allocation Models

**Conservative (Level 1)** - Target: 3%-4.5%
- Cash: 35% | Bonds: 40% | Hybrid: 15% | Equity: 8% | Gold: 2%

**Stable (Level 2)** - Target: 4%-6.5%
- Cash: 20% | Bonds: 30% | Hybrid: 20% | Domestic Equity: 18% | Overseas: 7% | Gold: 5%

**Balanced (Level 3)** - Target: 6%-10%
- Cash: 10% | Bonds: 20% | Hybrid: 20% | Domestic: 35% | Overseas: 10% | Gold: 5%

**Aggressive (Level 4)** - Target: 9%-18%
- Cash: 5% | Bonds: 10% | Hybrid: 15% | Domestic: 45% | Overseas: 18% | Gold: 7%

## Detailed References

See reference files for:
- `product-selection.md` - Fund/ETF selection criteria
- `rebalancing-protocol.md` - Rebalancing rules
- `macro-framework.md` - Macro analysis framework
- `behavioral-biases.md` - Behavioral finance biases

## Report Structure

Output comprehensive IPS report:
1. Client Financial Profile
2. Risk Assessment
3. Investment Goals
4. Macro Analysis
5. Strategic Asset Allocation
6. Product Selection Criteria
7. Execution Plan
8. Growth Projection
9. Stress Testing
10. Risk Management Rules
11. Investment Discipline
12. Monitoring Plan

## Disclaimer

⚠️ Investment involves risk
⚠️ Past performance doesn't predict future
⚠️ For reference only, not formal advice
