---
name: ASO
description: Optimize app store listings with keyword research, A/B testing, and conversion tactics for iOS and Android.
metadata: {"clawdbot":{"emoji":"📲","os":["linux","darwin","win32"]}}
---

# App Store Optimization Rules

## Keyword Research
- Competitor analysis: what keywords do top apps rank for?
- Search volume vs difficulty: long-tail converts better than head terms
- Seasonal keywords: plan metadata updates around trends
- Localize keyword research per market — direct translation misses local search patterns
- Track ranking changes weekly — ASO is continuous optimization

## iOS Metadata
- Title (30 chars): primary keyword + brand, front-load keywords
- Subtitle (30 chars): secondary keywords, benefit statement
- Keyword field (100 chars): no spaces after commas, no duplicates from title/subtitle
- Apple indexes title, subtitle, keyword field, and IAP names
- Promotional text doesn't affect ranking — use for timely updates

## Android Metadata  
- Title (30 chars): same rules as iOS
- Short description (80 chars): high keyword density, hooks user
- Long description (4000 chars): keywords in first and last paragraphs, 2-3% density
- Google indexes all text including reviews
- Developer name and URL affect rankings

## Visual Optimization
- First two screenshots = 80% of impression impact — make them count
- Show outcomes and benefits, not UI — "Lost 20lbs" not "Calorie tracker"
- Text overlays: large font, readable on small screens, localized
- Video preview: 15-30 seconds, hook in first 3s, works without sound
- Icon: simple, recognizable at 16px, stands out from competitors

## A/B Testing
- iOS Custom Product Pages: test up to 35 variants per page
- Google Store Listing Experiments: screenshots, descriptions, icons
- Test one element at a time — multiple changes hide winners
- Run tests to statistical significance — 7 days minimum
- Winner replaces default, start next test

## Conversion Optimization
- Ratings 4.0+ is table stakes — below kills conversion rate
- Review count signals credibility — more installs = more reviews flywheel
- "Editors' Choice" and featuring dramatically boost conversion
- Size under 100MB avoids WiFi-only download friction
- Recent updates signal active development

## Review Management
- Respond to all negative reviews within 24 hours
- Ask clarifying questions — often converts 1-star to 4-star after fix
- Update response after shipping fixes — reviewers can update rating
- Never argue, always empathize and offer solution
- Report fake reviews through official channels

## Localization
- Top 10 languages cover 80% of global downloads
- Cultural adaptation > literal translation — local idioms, examples
- Localize screenshots and video — text overlays must match language
- Local keyword research per language — search behavior differs
- Local pricing strategies — purchasing power varies

## Seasonal and Event Strategy
- Update metadata for holidays, events, seasons
- iOS LiveOps and In-App Events boost visibility
- Time updates to avoid review delays — submit 3+ days early
- Coordinate with marketing campaigns — consistent messaging

## Tracking and Analytics
- Impression to install conversion rate by source
- Keyword rankings daily — catch drops early
- Competitor tracking — their wins are your opportunities
- Attribution: which keywords drive paying users, not just installs
- Organic vs paid split — healthy apps have majority organic
