---
name: Twitter Command Center (Search + Monitor)
description: "Search X (Twitter) in real time, monitor trends, extract posts, and analyze social media data—perfect for social listening and intelligence gathering. Safe read-only operations by default."
homepage: https://openclaw.ai
metadata: {"openclaw":{"emoji":"🐦","requires":{"bins":["curl","python3"],"env":["AISA_API_KEY"]},"primaryEnv":"AISA_API_KEY"}}
---

# OpenClaw Twitter 🐦

**Twitter/X data access and automation for autonomous agents. Powered by AIsa.**

One API key. Full Twitter intelligence.

---

## ⚠️ IMPORTANT SECURITY NOTICE

This skill provides two types of operations:

### ✅ Read Operations (SAFE - Recommended for Most Users)
- User profiles, tweets, search, trends, followers
- **No authentication required**
- **No credentials transmitted**
- **Safe for production use**

### ⚠️ Write Operations (HIGH RISK - Use Only with Dedicated Accounts)
- Posting, liking, retweeting
- **Requires transmitting email + password + proxy to third-party API**
- **Security Risk**: Full account access granted to `api.aisa.one`

**⚠️ CRITICAL**: Never use write operations with your primary Twitter account. Create dedicated automation accounts only.

---

## 🔥 What Can You Do? (Safe Read Operations)

### Monitor Influencers
```
"Get Elon Musk's latest tweets and notify me of any AI-related posts"
```

### Track Trends
```
"What's trending on Twitter worldwide right now?"
```

### Social Listening
```
"Search for tweets mentioning our product and analyze sentiment"
```

### Competitor Intelligence
```
"Monitor @anthropic and @GoogleAI - alert me on new announcements"
```

### User Research
```
"Find AI researchers in the Bay Area and show their recent work"
```

---

## Quick Start

```bash
export AISA_API_KEY="your-key"
```

Get your API key at [aisa.one](https://aisa.one)

---

## Core Capabilities

### ✅ Read Operations (No Login Required - Safe)

All read operations are safe and require only your AIsa API key. No Twitter credentials needed.

#### Get User Information

```bash
curl "https://api.aisa.one/apis/v1/twitter/user/info?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Get User's Latest Tweets

```bash
curl "https://api.aisa.one/apis/v1/twitter/user/user_last_tweet?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Search Tweets (Advanced)

**Important**: `queryType` parameter is required (Latest or Top)

```bash
# Search latest tweets
curl "https://api.aisa.one/apis/v1/twitter/tweet/advanced_search?query=AI+agents&queryType=Latest" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Search top tweets
curl "https://api.aisa.one/apis/v1/twitter/tweet/advanced_search?query=AI+agents&queryType=Top" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Get Trending Topics

```bash
# Worldwide trends (woeid=1)
curl "https://api.aisa.one/apis/v1/twitter/trends?woeid=1" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Search Users

```bash
curl "https://api.aisa.one/apis/v1/twitter/user/search_user?keyword=AI+researcher" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Get Tweet Details by ID

```bash
curl "https://api.aisa.one/apis/v1/twitter/tweet/tweetById?tweet_ids=123456789" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Get User Followers

```bash
curl "https://api.aisa.one/apis/v1/twitter/user/user_followers?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Get User Followings

```bash
curl "https://api.aisa.one/apis/v1/twitter/user/user_followings?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

---

## ⚠️ Write Operations (High Risk - Requires Authentication)

**🚨 CRITICAL SECURITY WARNING**

Write operations require you to:
1. Send your Twitter email, password, and proxy credentials to `api.aisa.one`
2. Trust a third-party service with full account access
3. Accept responsibility for account security

**NEVER use these operations with:**
- ❌ Your primary Twitter account
- ❌ Accounts with sensitive data
- ❌ Verified or high-value accounts
- ❌ Accounts you cannot afford to lose

**ONLY use with:**
- ✅ Dedicated test/automation accounts
- ✅ Unique passwords not used elsewhere
- ✅ Accounts created specifically for this purpose
- ✅ After reviewing AIsa's security policies

**You acknowledge and accept all risks by using write operations.**

---

### Write Operations API Reference

> ⚠️ **Warning**: All write operations require prior authentication via login endpoint.

#### Step 1: Account Login (Async Operation)

```bash
curl -X POST "https://api.aisa.one/apis/v1/twitter/user_login_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "user_name": "test_automation_account",
    "email": "test@example.com",
    "password": "unique_password_here",
    "proxy": "http://user:pass@proxy-ip:port"
  }'
```

**Login is asynchronous** - check status after submission.

#### Step 2: Check Login Status

```bash
curl "https://api.aisa.one/apis/v1/twitter/get_my_x_account_detail_v3?user_name=test_automation_account" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

#### Post a Tweet

```bash
curl -X POST "https://api.aisa.one/apis/v1/twitter/send_tweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "user_name": "test_automation_account",
    "text": "Hello from OpenClaw!"
  }'
```

#### Like a Tweet

```bash
curl -X POST "https://api.aisa.one/apis/v1/twitter/like_tweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "user_name": "test_automation_account",
    "tweet_id": "1234567890"
  }'
```

#### Retweet

```bash
curl -X POST "https://api.aisa.one/apis/v1/twitter/retweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "user_name": "test_automation_account",
    "tweet_id": "1234567890"
  }'
```

#### Update Profile

```bash
curl -X POST "https://api.aisa.one/apis/v1/twitter/update_profile_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "user_name": "test_automation_account",
    "name": "New Name",
    "bio": "New bio"
  }'
```

---

## Python Client

### Safe Read Operations

```bash
# User operations (safe)
python3 {baseDir}/scripts/twitter_client.py user-info --username elonmusk
python3 {baseDir}/scripts/twitter_client.py tweets --username elonmusk
python3 {baseDir}/scripts/twitter_client.py followers --username elonmusk
python3 {baseDir}/scripts/twitter_client.py followings --username elonmusk

# Search & Discovery (safe)
python3 {baseDir}/scripts/twitter_client.py search --query "AI agents"
python3 {baseDir}/scripts/twitter_client.py user-search --keyword "AI researcher"
python3 {baseDir}/scripts/twitter_client.py trends --woeid 1
```

### ⚠️ Write Operations (High Risk)

**Only use with dedicated test accounts:**

```bash
# Login (use test account only!)
python3 {baseDir}/scripts/twitter_client.py login \
  --username test_automation_account \
  --email test@example.com \
  --password unique_password \
  --proxy "http://user:pass@ip:port"

# Check account status
python3 {baseDir}/scripts/twitter_client.py account --username test_automation_account

# Post operations (after login)
python3 {baseDir}/scripts/twitter_client.py post \
  --username test_automation_account \
  --text "Test post"

python3 {baseDir}/scripts/twitter_client.py like \
  --username test_automation_account \
  --tweet-id 1234567890

python3 {baseDir}/scripts/twitter_client.py retweet \
  --username test_automation_account \
  --tweet-id 1234567890
```

---

## API Endpoints Reference

### Read Operations (Safe)

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/twitter/user/info` | GET | Get user profile |
| `/twitter/user/user_last_tweet` | GET | Get user's recent tweets |
| `/twitter/user/user_followers` | GET | Get user followers |
| `/twitter/user/user_followings` | GET | Get user followings |
| `/twitter/user/search_user` | GET | Search users by keyword |
| `/twitter/tweet/advanced_search` | GET | Advanced tweet search |
| `/twitter/tweet/tweetById` | GET | Get tweets by IDs |
| `/twitter/trends` | GET | Get trending topics |

### Write Operations (⚠️ High Risk)

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/twitter/user_login_v3` | POST | Login to account ⚠️ |
| `/twitter/send_tweet_v3` | POST | Send a tweet ⚠️ |
| `/twitter/like_tweet_v3` | POST | Like a tweet ⚠️ |
| `/twitter/retweet_v3` | POST | Retweet ⚠️ |

---

## Pricing

| Operation | Cost per Request |
|-----------|-----------------|
| Read operations | ~$0.0004 |
| Write operations | ~$0.001 |

Every API response includes `usage.cost` and `usage.credits_remaining` fields.

---

## Getting Started

### Step 1: Get API Key
Sign up at [aisa.one](https://aisa.one) and obtain your API key.

### Step 2: Add Credits
AIsa uses pay-as-you-go pricing. Add credits to your account.

### Step 3: Set Environment Variable
```bash
export AISA_API_KEY="your-key-here"
```

### Step 4: Start with Read Operations
Begin with safe read operations to familiarize yourself with the API.

**Only proceed to write operations if you have a specific need and dedicated test account.**

---

## Security Best Practices

1. **Default to read-only** - Most use cases don't need write access
2. **Separate accounts** - Never mix automation with personal accounts
3. **Unique credentials** - Use unique passwords for automation accounts
4. **Environment variables** - Never hardcode credentials in scripts
5. **Monitor activity** - Regularly check your AIsa dashboard
6. **Rotate keys** - Periodically rotate API keys
7. **Minimal permissions** - Only use write operations when absolutely necessary
8. **Test thoroughly** - Always test with test accounts first
9. **Review ToS** - Understand both Twitter and AIsa terms of service
10. **Have a backup plan** - Be prepared for account suspension

---

## Documentation

- [Full API Reference](https://aisa.mintlify.app/api-reference/introduction)
- [AIsa Security Policies](https://aisa.one)
- [OpenClaw Documentation](https://openclaw.ai)
- [ClawHub Package](https://www.clawhub.com/aisa-one/openclaw-twitter)

---

## Support

- API Issues: Contact AIsa support at [aisa.one](https://aisa.one)
- Skill Issues: Open issue on GitHub
- Security Concerns: Review AIsa security documentation

---

## Disclaimer

This skill facilitates access to Twitter data through AIsa's API. Write operations require transmitting credentials to a third-party service. Users assume all responsibility and risk. The authors and AIsa are not liable for account suspension, data loss, or security breaches. Use at your own risk.
