# LLM Training & Alignment 论文阅读指南

阅读此类论文时，请特别关注以下方面：

## 1. 训练范式与训练方法
- **训练范式**：明确指出论文使用的训练范式
  - 预训练（Pre-training）
  - 监督微调（SFT / Supervised Fine-tuning）
  - 指令微调（Instruction Tuning）
  - 强化学习（RL）：PPO、REINFORCE、RRHF 等
  - 偏好对齐：RLHF、DPO、IPO、KTO、ORPO 等
  - 持续学习（Continual Learning）
  - 其他范式（Multi-task Learning、Meta-learning 等）
  
- **训练方法**：明确指出具体的训练技术
  - 全参微调（Full Fine-tuning）
  - 参数高效微调：LoRA、QLoRA、Adapter、Prefix-tuning、P-tuning 等
    - 如果使用 LoRA：秩（rank）、alpha、目标模块、dropout 等配置
  - 量化训练：QAT、PTQ、具体 bit 数
  - 知识蒸馏（Knowledge Distillation）
  - 其他方法
  
- **相关领域**： 明确指出论文是针对垂域任务，还是通用任务

## 2. 算法核心细节（必须讲清楚）
- **具体优化点是什么**：
  - 相比 baseline 或已有方法，本文的创新改进在哪里？
  - 是改进了损失函数、采样策略、数据构建，还是其他？
  
- **损失函数**：
  - 完整的损失函数表达式（数学公式）
  - 各项的含义与权重配置
  - 是否有正则化项、辅助损失等
  
- **模型参数更新方式**：
  - 使用什么优化器（Adam, AdamW, SGD, Lion 等）？
  - 学习率设置与调度策略（常数、余弦衰减、线性 warm-up 等）
  - Batch size、梯度累积步数
  - 梯度裁剪、权重衰减等配置
  - 参数更新频率（特别是 RL 中的策略更新）

## 3. 训练数据
- **数据来源**：
  - 在哪些数据上进行训练？
  - 数据规模（样本数、token 数）
  - 数据类型（文本、代码、多模态等）
  
- **数据收集方式**：
  - 公开数据集、爬虫、人工标注、模型生成（self-instruct, distillation）？
  - 数据清洗与质量控制流程
  - 数据去重、过滤规则
  
- **数据配比与采样**：
  - 不同数据源的混合比例
  - 采样策略（均匀采样、重要性采样等）

## 4. 训练效果与实验结果
- **主要 Benchmark 表现**：
  - 在哪些评测集上测试？
  - 具体得分与 SOTA 对比
  
- **消融实验**：
  - 各组件/超参数的影响分析
  - 哪些因素对性能影响最大？
  - 消融实验的具体数据与结论
  
- **与已有方法的对比**：
  - 对比了哪些 baseline 或竞品方法？
  - 在相同数据/计算资源下的公平对比
  - 性能提升幅度与统计显著性

## 5. 其他关键要素
- **数据策略**：训练数据如何构建？数据质量如何保证？
- **架构创新**（如有）：在 Transformer 基础上做了哪些改进？
- **Scaling 分析**：是否有 scaling law 分析？不同规模模型的表现趋势？
- **效率优化**：计算效率、内存优化、训练加速方面有何创新？
- **局限性与展望**：尚有哪些不足，未来工作方向
---

请在生成笔记时使用以下结构：
- **一句话总结**
- **训练范式与方法**（明确列出范式和方法）
- **核心算法**：
  - 具体优化点
  - 损失函数（数学公式）
  - 参数更新方式
- **训练数据**：
  - 数据来源与规模
  - 数据收集与处理方式
- **实验结果**：
  - 主要 benchmark 得分
  - 与已有方法对比
- **消融实验要点**
- **创新点**
- **局限性**

要求准确、专业，对技术细节要具体明确，不能含糊其辞。
