# SKILL.md - arxiv-cli-tools

## Metadata

| Key | Value |
|-----|-------|
| name | arxiv-cli-tools |
| description | Command-line interface for searching and downloading arXiv papers |
| author | OpenClaw |
| version | 0.1.0 |
| license | MIT |
| upstream | https://pypi.org/project/arxiv-cli-tools/ |

## Installation

### Option 1: pipx (推荐)

```bash
pipx install arxiv-cli-tools
```

### Option 2: pip

```bash
pip install arxiv-cli-tools
```

## Usage

### 搜索论文

```bash
arxiv-cli search "prompt engineering" -n 5 --summary
```

常用选项:
- `-n, --num` - 结果数量限制
- `--summary` - 显示摘要
- `--authors` - 按作者过滤
- `--categories` - 按分类过滤

### 下载论文

```bash
arxiv-cli download --id 2101.01234 --id 2105.06789 --dest papers --skip-existing
```

常用选项:
- `--id` - 论文ID（可多次使用）
- `--dest` - 下载目录
- `--skip-existing` - 跳过已存在的文件
- `--pdf` - 下载PDF格式

### 查看帮助

```bash
arxiv-cli --help
arxiv-cli search --help
arxiv-cli download --help
```

## Examples

搜索最新5篇关于深度学习的论文:
```bash
arxiv-cli search "deep learning" -n 5 --summary
```

按作者搜索:
```bash
arxiv-cli search "attention mechanism" --authors "Vaswani"
```

下载特定论文到指定目录:
```bash
arxiv-cli download --id 1706.03762 --dest ~/papers
```

## Notes

- 该工具基于 [arxiv](https://pypi.org/project/arxiv/) Python 客户端构建
- 不需要 API 密钥
- 请遵守 arXiv 的使用条款和速率限制
