---
name: Article
description: Create compelling articles using journalistic standards and engagement optimization for maximum reader impact.
---

## Lead Hook Formula

Deploy opening patterns that immediately capture attention:
- **Question hook**: "What if everything you know about X is wrong?"
- **Statistic hook**: "83% of professionals make this critical mistake daily"
- **Scene hook**: "At 3:47 AM, the alarm changed everything"
- **Conflict hook**: "The billion-dollar industry nobody talks about"

First sentence maximum: 25 words. Include core information within first 100 words.

## Source Hierarchy Standards

Apply journalism credibility levels:
- **Primary sources (minimum 60%)**: Direct witnesses, original documents, participants
- **Expert sources (20-30%)**: Verified credentials and relevant authority
- **Secondary sources (maximum 20%)**: Studies, reports, other journalism

Quote attribution format: "Statement," said Source Name, title/organization.
Anonymous sources only when information unavailable elsewhere—include anonymity reason.

## Fact-Checking Protocol

Implement three-layer verification system:
1. **Source credibility**: Check credentials, conflicts of interest, publication history
2. **Information accuracy**: Cross-reference with 2+ independent sources
3. **Context integrity**: Verify quotes not taken out of context

Red-flag indicators requiring additional verification:
- Superlatives ("first ever", "unprecedented")
- Convenient statistics supporting source's position
- Claims that seem too good/bad to be true

## Readability Optimization Targets

Calibrate complexity for audience:
- **General public**: Flesch-Kincaid Grade Level 6-8, sentence average 15-20 words
- **Professional audience**: Grade Level 9-12, sentence average 18-25 words
- **Technical audience**: Grade Level 13-16, sentence average 20-30 words

Jargon limits: <5% for general public, <15% for professionals, unlimited for technical (with definitions).

## Engagement Structure Rules

Maintain attention using systematic placement:
- **Subheadings**: Every 150-200 words for digital, 300-400 for print
- **Quotes**: Every 3-4 paragraphs, vary length (5-25 words)
- **Paragraph length**: 2-3 sentences average, never exceed 5 sentences
- **Lists/bullets**: Every 500-700 words for digital content

Transition patterns: "Moreover", "However", "Meanwhile", "As a result" for logical flow.

## SEO Integration Without Compromise

Optimize search visibility naturally:
- **Primary keyword density**: 1-2% of total word count, natural placement only
- **Header hierarchy**: H2 every 300-500 words, H3 for subsections
- **Meta elements**: Title 50-60 characters, description 150-160 characters
- **External links**: 2-3 authoritative sources per 1000 words

Content-first principle: Write complete article, then optimize through natural revision.

## Publication Voice Adaptation

Adjust tone for platform requirements:
- **News reporting**: Objective stance, minimal opinion, multiple perspectives
- **Opinion pieces**: Clear position statement, evidence-based arguments, counterpoint acknowledgment
- **Feature writing**: Narrative elements allowed, character development, scene-setting

Active voice minimum: 70% of sentences. Passive voice only for emphasis or unknown subjects.
