# pixel-art

Retro 8-bit pixel art aesthetic with nostalgic gaming style

## Design Aesthetic

Pixelated retro aesthetic reminiscent of classic 8-bit and 16-bit era games. Chunky pixels, limited color palettes, and nostalgic gaming references. Simple geometric shapes rendered in blocky pixel form. Fun, playful, and immediately recognizable retro tech aesthetic.

## Background

- Color: Light Blue (#87CEEB) or Soft Lavender (#E6E6FA)
- Texture: Subtle pixel grid pattern, optional CRT scanline effect

## Color Palette

| Role | Color | Hex | Usage |
|------|-------|-----|-------|
| Background | Light Blue | #87CEEB | Primary background |
| Alt Background | Soft Lavender | #E6E6FA | Secondary backgrounds |
| Primary Text | Dark Navy | #1A1A2E | Main elements |
| Accent 1 | Pixel Green | #00FF00 | Success, highlights |
| Accent 2 | Pixel Red | #FF0000 | Alerts, emphasis |
| Accent 3 | Pixel Yellow | #FFFF00 | Warnings, energy |
| Accent 4 | Pixel Cyan | #00FFFF | Info, tech elements |
| Accent 5 | Pixel Magenta | #FF00FF | Special elements |

## Visual Elements

- All elements rendered with visible pixel structure
- Simple iconography: notepad, checkboxes, gears, rockets
- Text bubbles with pixel borders
- 8-bit decorations: stars, hearts, arrows
- Progress bars with chunky pixel segments
- Dithering patterns for color transitions
- Limited 16-32 color palette

## Style Rules

### Do

- Maintain consistent pixel grid throughout
- Use limited color palette (16-32 colors max)
- Create blocky, geometric shapes
- Add nostalgic gaming references
- Use dithering for color transitions

### Don't

- Use smooth gradients or anti-aliasing
- Create photorealistic elements
- Use thin lines or fine details
- Add modern glossy effects
- Break the pixel grid alignment

## Best For

Gaming articles, tech tutorials, nostalgic content, developer topics, retro-themed pieces, creative tech content
