---
name: aria2
description: 使用 aria2 下载磁力链接、种子、HTTP 文件。下载完成后自动转存到 115 网盘并删除本地文件。当用户发送磁力链接(magnet:)、种子文件(.torrent)、或要求下载文件时触发此 skill。
---

# Aria2 下载管理

aria2 以 daemon 模式运行，通过 RPC 接口管理任务。

## 配置

- **配置文件**: 请根据实际情况调整 `aria2.conf` 路径
- **RPC 端口**: 6800 (默认)
- **RPC 密钥**: 请在指令中使用 `<YOUR_RPC_SECRET>` 或配置环境变量
- **下载目录**: 根据主机情况调整

## 添加下载任务

### 磁力链接或 HTTP

```bash
# 请将 <YOUR_RPC_SECRET> 替换为实际密钥
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.addUri","params":["token:e603c18b871468e81ec2b2458d3356e5",["<URL>"]]}'
```

### 种子文件

```bash
# 先 base64 编码
TORRENT_B64=$(base64 -w0 /path/to/file.torrent)
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d "{\"jsonrpc\":\"2.0\",\"id\":\"1\",\"method\":\"aria2.addTorrent\",\"params\":[\"token:e603c18b871468e81ec2b2458d3356e5\",\"$TORRENT_B64\"]}"
```

## 查看任务状态

### 所有活动任务

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.tellActive","params":["token:e603c18b871468e81ec2b2458d3356e5"]}' | jq '.result[] | {gid, status, completedLength, totalLength, downloadSpeed, files: [.files[].path]}'
```

### 指定任务 (用 GID)

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.tellStatus","params":["token:e603c18b871468e81ec2b2458d3356e5","<GID>"]}' | jq '{status, completedLength, totalLength, downloadSpeed}'
```

### 等待中的任务

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.tellWaiting","params":["token:e603c18b871468e81ec2b2458d3356e5",0,10]}'
```

### 已完成/已停止的任务

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.tellStopped","params":["token:e603c18b871468e81ec2b2458d3356e5",0,10]}'
```

## 控制任务

### 暂停

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.pause","params":["token:e603c18b871468e81ec2b2458d3356e5","<GID>"]}'
```

### 继续

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.unpause","params":["token:e603c18b871468e81ec2b2458d3356e5","<GID>"]}'
```

### 删除

```bash
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.remove","params":["token:e603c18b871468e81ec2b2458d3356e5","<GID>"]}'
```

## 下载完成后自动流程

本 Skill 需要配合主机端的自动转存脚本使用。建议在 `aria2.conf` 中配置 `on-download-complete` 钩子。

## 检查服务状态

```bash
# 检查 aria2 daemon 是否运行
curl -s http://localhost:6800/jsonrpc -H "Content-Type: application/json" \
  -d '{"jsonrpc":"2.0","id":"1","method":"aria2.getVersion","params":["token:e603c18b871468e81ec2b2458d3356e5"]}'

## 快速命令格式

用户发送类似以下格式时直接添加下载：
- `/aria2 magnet:?xt=urn:btih:...`
- `/aria2 https://example.com/file.zip`
- `下载这个磁力 magnet:?xt=...`
