# Argos Product Research Skill Configuration
# Copy this file to 'config' and customize as needed

# Default search settings
DEFAULT_SORT=relevance          # Options: relevance, price, price-desc, rating
DEFAULT_RESULTS_LIMIT=10        # Maximum products to show in search results
DEFAULT_COMPARISON_LIMIT=4      # Maximum products to compare at once

# Price display
SHOW_SAVINGS=true               # Show savings when products are on sale
SHOW_PRICE_PER_UNIT=true        # Show price per unit where applicable

# Review settings
MIN_REVIEWS_FOR_SUMMARY=10      # Minimum reviews needed for reliable summary
SHOW_VERIFIED_ONLY=false        # Only show verified purchaser reviews

# Output formatting
USE_TABLES=true                 # Use markdown tables for results
SHOW_PRODUCT_IMAGES=false       # Include image URLs in output
TRUNCATE_DESCRIPTIONS=200       # Max characters for brief descriptions

# Cache settings (optional)
CACHE_ENABLED=false             # Cache product data locally
CACHE_TTL_MINUTES=60            # How long to cache data
