# Argos Product Research Skill 🛒

An OpenClaw skill for searching, comparing, and researching products from Argos.co.uk with natural language queries.

## Features

- **Product Search** - Natural language search with price, category, and rating filters
- **Product Details** - Full specifications, pricing, and availability
- **Product Comparison** - Side-by-side comparison of 2-4 products
- **Review Summary** - Aggregated pros/cons from customer reviews

## Installation

### Via ClawHub
```bash
npx skills add argos-product-research -g -y
```

### Manual Installation
1. Download or clone this repository
2. Place the `argos-product-research` folder in your skills directory
3. The skill will be automatically loaded by OpenClaw

## Usage

### Search for Products
```
/argos search wireless headphones under £100
/argos search best rated air fryer
/argos search gaming laptop with RTX 4060
```

### Get Product Details
```
/argos details 9876543
/argos details Ninja Air Fryer AF100UK
```

### Compare Products
```
/argos compare 123456,789012,345678
/argos compare Dyson V15, Shark NZ801UK, Henry HVR160
```

### Summarize Reviews
```
/argos reviews 9876543
```

## Example Output

### Search Results
```
## Argos Vacuum Cleaners (Under £200, Top Rated)

| Product | Price | Rating | Type |
|---------|-------|--------|------|
| Henry HVR160 | £129 | 4.9★ (2,847 reviews) | Corded Cylinder |
| Shark NZ801UK | £179 | 4.8★ (1,203 reviews) | Cordless Upright |
| Dyson V8 Origin | £199 | 4.7★ (956 reviews) | Cordless Stick |

Would you like me to compare any of these or show detailed specs?
```

### Product Comparison
```
## Product Comparison: Vacuum Cleaners

| Feature | Henry HVR160 | Shark NZ801UK |
|---------|--------------|---------------|
| Price | £129 | £179 |
| Rating | 4.9★ | 4.8★ |
| Type | Corded | Cordless |
| Runtime | Unlimited | 60 mins |
| Weight | 8.5kg | 4.1kg |

### Recommendation
Choose **Henry HVR160** for best value and unlimited runtime.
Choose **Shark NZ801UK** for cordless convenience.
```

## Supported Filters

- **Price range**: "under £100", "between £50-£200", "max £150"
- **Rating**: "best rated", "top rated", "highest rated"
- **Brand**: Include brand name in search
- **Category**: Include product type/category in search
- **Sort**: Results default to relevance, can sort by price or rating

## Requirements

- OpenClaw or Claude Code with skill support
- Web access for fetching Argos product data

## Limitations

- Product data is fetched in real-time; availability may vary
- Some product pages may have different structures
- Rate limiting may apply for frequent requests

## Contributing

Contributions welcome! Please submit issues and pull requests to improve the skill.

## License

MIT License - See LICENSE file for details.

---

**Made for [ClawHub](https://www.clawhub.ai)** - The marketplace for AI agent skills
