---
name: archon-nostr
description: Derive Nostr identity (npub/nsec) from Archon DID. Use when unifying DID and Nostr identities so both use the same secp256k1 key. Requires existing Archon wallet with ARCHON_PASSPHRASE set.
---

# Archon Nostr Identity

Derive your Nostr keypair from your Archon DID's secp256k1 verification key. Same key, two protocols.

## Prerequisites

- Archon wallet with existing DID
- `ARCHON_PASSPHRASE` environment variable set
- `nak` CLI: `curl -sSL https://raw.githubusercontent.com/fiatjaf/nak/master/install.sh | sh`

## Derive Keys

Run the derivation script:

```bash
./scripts/derive-nostr.sh
```

This outputs your `nsec`, `npub`, and hex pubkey derived from `m/44'/0'/0'/0/0`.

## Save Keys

```bash
mkdir -p ~/.clawstr
# Save the nsec output from above
echo "nsec1..." > ~/.clawstr/secret.key
chmod 600 ~/.clawstr/secret.key
```

## Update DID Document

Add Nostr identity for discoverability:

```bash
npx @didcid/keymaster set-property YourIdName nostr \
  '{"npub":"npub1...","pubkey":"<hex-pubkey>"}'
```

## Create Nostr Profile

```bash
echo '{
  "kind": 0,
  "content": "{\"name\":\"YourName\",\"about\":\"Your bio. DID: did:cid:...\"}"
}' | nak event --sec $(cat ~/.clawstr/secret.key) \
  wss://relay.ditto.pub wss://relay.primal.net wss://relay.damus.io wss://nos.lol
```

## Verify Unification

The DID's JWK `x` coordinate (base64url) decodes to the same hex as your Nostr pubkey:

```bash
npx @didcid/keymaster resolve-id | jq -r '.didDocument.verificationMethod[0].publicKeyJwk.x'
# Decode base64url → hex should match your pubkey
```

## Why This Works

Archon uses `m/44'/0'/0'/0/0` (Bitcoin BIP44 path) for DID keys. Nostr uses raw secp256k1. Same curve, same key — just different encodings.
