---
name: free-worker-dispatch
description: Route tasks to free AI models via OpenRouter to save money. Use when the agent needs to delegate content writing, research, code generation, or other tasks to cheaper/free models instead of using expensive primary models. Prevents surprise API bills.
user-invocable: true
metadata: {"openclaw": {"emoji": "🏭", "os": ["darwin", "linux"], "requires": {"bins": ["python3"], "env": ["OPENROUTER_API_KEY"]}}}
---

# Free Worker Dispatch

Delegate tasks to free AI models via OpenRouter. Save your expensive primary model for strategy and quality review — let free models handle the grunt work.

## Why This Exists

Running everything through Claude Opus or GPT-4 costs real money. Free models on OpenRouter handle most content, research, and coding tasks perfectly well. This skill routes tasks intelligently, saving agents from surprise bills.

## Available Free Models

| Model | Best For | Context |
|-------|----------|---------|
| `stepfun/step-3.5-flash:free` | Research, analysis, brainstorming | 128K |
| `arcee-ai/trinity-large-preview:free` | SEO copy, blog posts, marketing | 128K |
| `openrouter/free` | Auto-route to best available free model | Varies |

## Commands

### Dispatch a task to a free model
```bash
python3 {baseDir}/scripts/dispatch.py task --prompt "Write a blog post about freelance copywriting rates in 2026" --model "arcee-ai/trinity-large-preview:free"
```

### Dispatch with auto-model selection
```bash
python3 {baseDir}/scripts/dispatch.py task --prompt "Research the top 10 Notion templates for freelancers" --type research
```

### List available free models
```bash
python3 {baseDir}/scripts/dispatch.py models
```

### Check model status (is it up?)
```bash
python3 {baseDir}/scripts/dispatch.py status --model "stepfun/step-3.5-flash:free"
```

### Dispatch with output to file
```bash
python3 {baseDir}/scripts/dispatch.py task --prompt "Write an email newsletter about AI tools" --type content --output newsletter-draft.md
```

### Batch dispatch (multiple tasks)
```bash
python3 {baseDir}/scripts/dispatch.py batch --file tasks.json
```

The tasks.json format:
```json
[
  {"prompt": "Write a product description", "type": "content"},
  {"prompt": "Research competitor pricing", "type": "research"},
  {"prompt": "Generate a Python script for...", "type": "code"}
]
```

## Task Types

The `--type` flag auto-selects the best free model:

| Type | Model | Why |
|------|-------|-----|
| `research` | stepfun/step-3.5-flash:free | Fast, good at analysis |
| `content` | arcee-ai/trinity-large-preview:free | Strong at writing |
| `code` | openrouter/free | Auto-routes to best coder |
| `general` | openrouter/free | Let OpenRouter decide |

## Output

Results are printed to stdout by default. Use `--output <file>` to save to a file. Use `--json` for structured JSON output including model used, tokens, and timing.

## Tips

- Always review worker output before publishing — free models hallucinate
- Use `--type` for best model matching instead of specifying models directly
- Batch dispatch is faster for multiple independent tasks
- If a model is down, the script falls back to `openrouter/free`
