---
name: compliance-audit
description: Immutable audit trail for autonomous agent operations. Log skill executions, data access, decisions, and budget changes with tamper-evident hashes. Essential for enterprise governance, incident response, and trust verification.
user-invocable: true
metadata: {"openclaw": {"emoji": "📋", "os": ["darwin", "linux"], "requires": {"bins": ["python3"]}}}
---

# Compliance Audit Trail

Immutable, tamper-evident audit logging for autonomous agents. Every action gets a hash-chained entry that can be verified for integrity.

## Why This Exists

Autonomous agents make decisions, execute skills, access data, and spend money without human oversight. When something goes wrong, you need to know exactly what happened. Current agent frameworks have no standard audit trail — this fills that gap.

## Commands

### Log an action
```bash
python3 {baseDir}/scripts/audit.py log --action "skill_executed" --details '{"skill": "scanner", "target": "some-skill", "result": "clean"}'
```

### Log a decision
```bash
python3 {baseDir}/scripts/audit.py log --action "decision" --details '{"choice": "deploy v2", "reason": "all tests passed", "alternatives_considered": ["rollback", "hotfix"]}'
```

### Log data access
```bash
python3 {baseDir}/scripts/audit.py log --action "data_access" --details '{"resource": "api_key", "purpose": "moltbook_post", "accessor": "ghost_agent"}'
```

### Log a budget change
```bash
python3 {baseDir}/scripts/audit.py log --action "budget_change" --details '{"amount": -10.00, "merchant": "namecheap", "reason": "domain purchase", "balance_after": 190.00}'
```

### View recent entries
```bash
python3 {baseDir}/scripts/audit.py view --last 20
```

### View entries by action type
```bash
python3 {baseDir}/scripts/audit.py view --action skill_executed
```

### View entries in a time range
```bash
python3 {baseDir}/scripts/audit.py view --since "2026-02-15T00:00:00" --until "2026-02-16T00:00:00"
```

### Verify audit trail integrity
```bash
python3 {baseDir}/scripts/audit.py verify
```

### Export audit trail
```bash
python3 {baseDir}/scripts/audit.py export --format json > audit-export.json
python3 {baseDir}/scripts/audit.py export --format csv > audit-export.csv
```

### Generate compliance summary
```bash
python3 {baseDir}/scripts/audit.py summary --period day
```

## Entry Format

Each audit entry contains:
- **timestamp** — ISO 8601, UTC
- **action** — what happened (skill_executed, decision, data_access, budget_change, error, custom)
- **agent** — which agent performed the action
- **details** — structured JSON with action-specific data
- **hash** — SHA-256 hash chaining previous entry's hash + current entry (tamper-evident)
- **sequence** — monotonically increasing sequence number

## Integrity Verification

The audit trail is hash-chained: each entry includes a SHA-256 hash of the previous entry's hash concatenated with the current entry's data. If any entry is modified or deleted, the chain breaks and `verify` will report the exact point of tampering.

## Storage

Audit logs are stored in `~/.openclaw/audit/` as daily JSON files (`audit-YYYY-MM-DD.json`). This keeps individual files small while maintaining the full history.

## Use Cases

- **Incident response**: What happened in the 5 minutes before the error?
- **Budget accountability**: Show every dollar spent and why
- **Trust verification**: Prove your agent hasn't been compromised
- **Enterprise compliance**: Meet audit requirements for autonomous systems
- **Debugging**: Trace the decision chain that led to an unexpected outcome
