---
name: Arabic
description: Write Arabic that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Arabic is technically correct but sounds off. Too formal. Too فصحى (classical). Natives blend registers and use colloquial naturally. Match that.

## MSA vs Dialect

Critical distinction:
- فصحى (MSA): news, formal writing, academia, religion
- عامية (dialect): daily life, social media, texting, casual
- Most online communication uses dialect or MSA-dialect mix
- Pure MSA in casual contexts = robotic, unnatural

## Regional Dialects

If region known, commit:
- Egyptian: أيوه، عامل إيه، كده، خالص
- Levantine: هلا، كيفك، هيك، كتير
- Gulf: شلونك، واجد، زين، يالله
- Moroccan: لاباس، واخا، بزاف
- Don't mix. Each dialect has distinct vocabulary.

## Formality Default

Default is too formal. Unless explicitly formal:
- Use dialect or light MSA
- Contractions and shortcuts are normal
- Colloquial expressions welcome

## Greetings

Natural greetings vary by context:
- Casual: مرحبا، هلا، أهلين
- Religious: السلام عليكم (formal/religious)
- Egyptian: إزيك، عامل إيه
- Gulf: شلونك، شخبارك

## Common Expressions

Natural expressions:
- إن شاء الله: "hopefully" (overuse is native!)
- يعني: filler, "I mean", "like"
- الله يعطيك العافية: appreciation
- ما شاء الله: admiration
- يلا: "let's go", "come on"

## Fillers & Flow

Real Arabic has fillers:
- يعني، طيب، خلاص
- هيك/كده، بس، أصلاً
- والله، صراحة
- عادي، مش مشكلة

## Reactions

React naturally:
- والله؟، جد؟، معقول؟
- يا سلام!، ما شاء الله!
- هههههه، 😂
- يا ريت، إن شاء الله

## Sentence Structure

Casual Arabic is flexible:
- Topic fronting for emphasis
- Fragments are natural
- Questions without question marks common
- Answers can be very short

## Script Choices

Be consistent:
- Full Arabic script: السلام عليكم
- Some use Arabizi (Latin): salam, 3aleikom, yalla
- Arabizi common in casual texting
- 3=ع, 7=ح, 5=خ, 2=ء

## Expressiveness

Don't pick the safe word:
- كويس → ممتاز، رهيب، خرافي
- سيء → زفت، مش ولا بد، خايس
- كثير → واجد، مرة، بزاف

## Politeness Particles

Add warmth naturally:
- الله يخليك، لو سمحت
- تسلم/تسلمي، مشكور/ة
- الله يعافيك، الله يسعدك

## The "Native Test"

Before sending: would an Arab screenshot this as "AI-generated"? If yes—too MSA, no يعني, too formal. Add عامية flavor.
