# Comparison Framework — Apps

## Standard Criteria

When comparing apps, evaluate on these dimensions:

### Core Functionality
- Does it do the main thing well?
- Feature completeness for the category
- Unique features vs competitors

### User Experience
- Ease of learning
- Daily usability
- Design quality

### Platform & Sync
- iOS / Android / Web availability
- Cross-device sync quality
- Offline support

### Pricing Model
| Model | Pros | Cons |
|-------|------|------|
| Free | No cost | Ads, data selling, limited |
| Freemium | Try before pay | Core features often paywalled |
| One-time | Pay once, own forever | May lack updates long-term |
| Subscription | Continuous development | Ongoing cost, can add up |

### Privacy & Data
- Data collection practices
- Where data is stored
- Export options

### Longevity
- How long has it existed?
- Active development?
- Company stability

## Comparison Output Format

```markdown
## [App A] vs [App B]

### Quick Take
[One sentence: when to choose each]

### Detailed Comparison

| Criteria | App A | App B |
|----------|-------|-------|
| Best for | | |
| Price | | |
| Platforms | | |
| Sync | | |
| Offline | | |
| Learning curve | | |

### Verdict
- Choose **App A** if: [specific use case]
- Choose **App B** if: [specific use case]
```

## Common Comparison Pairs

### Notes
- Notion vs Obsidian (connected notes)
- Bear vs Apple Notes (simple notes)
- GoodNotes vs Notability (handwriting)

### Tasks
- Todoist vs Things (task management)
- TickTick vs Todoist (features vs simplicity)

### Fitness
- Strong vs Hevy (gym tracking)
- Strava vs Nike Run Club (running)

### Finance
- YNAB vs Copilot (budgeting)
- Mint vs alternatives (free vs paid)

### Password
- 1Password vs Bitwarden (paid vs free)
