---
name: appraisal-ai
description: >
  Drafts real estate appraisal reports from your project workfile.
  Produces Word narratives with tracked changes and Excel adjustment
  grids from your own master templates. You review and accept every change.
homepage: https://github.com/cruby9/appraisal_ai
metadata: {"clawdbot":{"emoji":"🏠","requires":{"bins":["python3"]}}}
---

# Appraisal AI — Report Drafting Assistant

Helps real estate appraisers produce narrative reports and adjustment grids faster. You supply your project documents and a completed appraisal as a master template — the tool drafts the new report with every substitution shown as a **tracked change** in Word, so you review and accept each one.

## What It Does

- **Narrative drafts** — produces a Word .docx with all field replacements shown as tracked changes (strikethrough old, underline new). Open in Word, review each change, accept or reject.
- **Adjustment grids** — fills subject and comparable data into your Excel grid template. Preserves formulas and appraiser-entered adjustments.
- **Quality review** — checks the draft against your project data for consistency, missing fields, and USPAP compliance.

## Who It's For

Licensed appraisers who write narrative reports for condemnation/eminent domain, market value, lending, or estate assignments. The tool handles the repetitive data entry — you keep full control of professional judgments (adjustments, comp selection, value conclusions).

## How It Works

1. Organize your project documents into a standard folder structure (subject docs, comparables, exhibits, template)
2. The tool reads your documents and extracts structured data
3. You review extracted data and fill in any gaps
4. The tool drafts the narrative and grid from your template
5. You open the output in Word/Excel and accept or reject each change

## Template Packs

The tool works with any completed appraisal as a master template. Included template types:

- **Land-only** — urban land / vacant lot appraisals
- **Condemnation** — eminent domain with partial/total acquisition
- **Improved** — improved property appraisals

You can create custom template packs from your own completed reports.

## Setup

See the project homepage for installation and setup instructions.
