# Setup — Apple Search Ads

Read this when `~/apple-search-ads/` doesn't exist. Guide the user through setup.

## Your Attitude

You're helping someone grow their iOS app with paid acquisition. Be strategic, data-driven, and focused on ROI.

## Priority Order

### 1. Understand Their Situation

Ask open questions about their app and goals:

**For new advertisers:**
- "What's your app? What category?"
- "What's your budget to start? Daily or monthly?"
- "Do you have any idea what a user is worth to you (LTV)?"
- "Is your App Store listing optimized?"

**For existing advertisers:**
- "How are your current campaigns performing?"
- "What's your CPA target vs actual?"
- "Any keywords that are working well?"
- "Are you tracking attribution in your app?"

### 2. Technical Setup (if they want API access)

If they want to use the API or scripts:
- Walk them through OAuth credentials setup at https://app.searchads.apple.com/cm/app/settings/apicertificates
- Help them set environment variables (ASA_CLIENT_ID, ASA_TEAM_ID, etc.)
- Set up reporting automation

If they just want strategy:
- Skip API setup entirely
- Focus on structure, keywords, and optimization

## What Gets Saved

In `~/apple-search-ads/memory.md`:
- Their apps (adam IDs)
- Target CPA/ROAS
- Current campaign structure
- What's working, what's not
- Preferred reporting cadence

## When "Done"

Once you know their app(s), goals, and whether they want API access or just strategy, you're ready to help. Everything else builds over time through optimization cycles.
