---
name: apple-notes-custom
description: Apple Notes.app integration for macOS. List folders, read, create, search, edit, and delete notes via AppleScript.
metadata: {"clawdbot":{"emoji":"📝","os":["darwin"]}}
---

# Apple Notes

Interact with Notes.app via AppleScript. Run scripts from: `cd {baseDir}`

## Commands

| Command | Usage |
|---------|-------|
| List folders | `scripts/notes-folders.sh [--tree] [--counts]` |
| List notes | `scripts/notes-list.sh [folder] [limit]` |
| Read note | `scripts/notes-read.sh <name-or-id> [folder]` |
| Create note | `scripts/notes-create.sh <folder> <title> [body]` |
| Search notes | `scripts/notes-search.sh <query> [folder] [limit] [--title-only]` |
| Edit note | `scripts/notes-edit.sh <name-or-id> <new-body> [folder]` |
| Delete note | `scripts/notes-delete.sh <name> <folder>` ⚠️ folder required |

## Folder Paths

All commands support subfolder paths with `/` separator:

```bash
scripts/notes-list.sh "Scanned/Medical & Health" 10
scripts/notes-read.sh "blood test" "Scanned/Medical & Health"
scripts/notes-create.sh "Property/416 Garfield" "Inspection notes" "Roof looks good"
```

### Folder Tree Structure

This collection has 4000+ notes. Key structure:

- **Scanned** — parent folder with many subfolders (Medical & Health, Receipts, etc.)
- **Fetish** — parent with subfolders (AW, Bimbo, Events, etc.)
- **Hobbies** — parent with subfolders (3d printing, Homelab, etc.)
- **Property** — subfolders per address

Use `--tree --counts` to see the full hierarchy.

## Folder Listing

```bash
scripts/notes-folders.sh                  # Flat list
scripts/notes-folders.sh --counts         # With note counts
scripts/notes-folders.sh --tree --counts  # Full hierarchy with counts
```

## Listing Notes

```bash
scripts/notes-list.sh "Notes" 10                      # Specific folder
scripts/notes-list.sh "Scanned/Receipts" 5             # Subfolder
scripts/notes-list.sh "" 10                             # All folders (shows folder name per note)
```

Without a folder, output includes the folder column: `ID | Date | Folder | Title`
With a folder: `ID | Date | Title`

## Reading Notes

```bash
scripts/notes-read.sh "blood test" "Scanned/Medical & Health"   # By name (partial match)
scripts/notes-read.sh "x-coredata://…/ICNote/p12345"            # By ID (direct lookup, fast)
```

Output: Title, Folder, Modified date, ID, then body text.

## Searching

Title search first (fast), body search fallback (slower):

```bash
scripts/notes-search.sh "tax" "" 10                    # All folders
scripts/notes-search.sh "receipt" "Scanned/Receipts" 5  # Specific folder
scripts/notes-search.sh "keyword" "" 10 --title-only    # Skip body search
```

Output: `ID | Date | Folder | Title`

## Creating Notes

```bash
scripts/notes-create.sh "Notes" "My Title" "Body text here"   # With body
scripts/notes-create.sh "Notes" "Empty Note"                    # Title only
```

Returns the created note's ID.

## Editing Notes

```bash
scripts/notes-edit.sh "My Note" "New body content" "Notes"              # By name
scripts/notes-edit.sh "x-coredata://…/ICNote/p12345" "New body"         # By ID
```

## Deleting Notes

```bash
scripts/notes-delete.sh "Old Note" "Notes"                    # Folder required
scripts/notes-delete.sh "receipt" "Scanned/Receipts"
```

⚠️ Folder argument is **required** for safety — prevents accidental matches across 4000+ notes.

## Performance Tips

| Situation | Tip |
|-----------|-----|
| Listing/searching all notes | **Always specify a folder** — iterating 4000+ notes is slow |
| Reading a known note | Use the **ID** from a previous list/search — instant lookup |
| Searching large folders | Use `--title-only` if body search isn't needed |
| Finding the right folder | Use `--tree --counts` first to see hierarchy |

## Errors

| Error | Cause |
|-------|-------|
| `Error: Can't get folder` | Folder name doesn't exist or wrong path |
| `No note matching…` | No partial match found in scope |
| Empty body text | Scanned/image-only notes have no extractable text |

## Technical Notes

- Partial name matching for read/edit/delete (first match wins)
- Multiline body supported via temp files
- Folder names are case-sensitive
- All user inputs escaped for AppleScript safety (quotes, backslashes)
- `number of` used instead of `count of` (AppleScript reserved word)
