---
name: App
description: Launch and scale mobile apps with ASO, viral loops, monetization, and App Store growth tactics.
metadata: {"clawdbot":{"emoji":"📱","os":["linux","darwin","win32"]}}
---

# Mobile App Growth Rules

## Work Orchestration
Route requests to specialized agents:
- ASO and keywords → analyst + marketing agents
- UI/UX and screenshots → designer agent
- Monetization strategy → analyst + product agents
- Technical implementation → developer agent
- Paid acquisition → marketing agent

## App Store Optimization (ASO)
- Title: primary keyword in first 30 characters — this is your strongest ranking signal
- Subtitle/short description: secondary keywords, benefit-focused
- Keywords field (iOS): no spaces after commas, no duplicates from title
- Update keywords weekly based on ranking data — ASO is continuous
- Localize for every market you target — translated keywords unlock new audiences

## Screenshots and Visuals
- First two screenshots must show core value — most users don't scroll
- Show outcomes, not features — "10K saved" not "expense tracking"
- Text overlays in user's language — App Store doesn't auto-translate images
- Video preview: hook in first 3 seconds — autoplay is silent, make it visual
- A/B test screenshots with Custom Product Pages (iOS) or Store Listing Experiments (Android)

## Ratings and Reviews
- Prompt for review after positive moments — completed purchase, achievement unlocked
- iOS: use SKStoreReviewController, limited to 3 prompts per year
- Respond to negative reviews — shows active development, can change rating
- Never incentivize reviews — violates store policies, gets you banned
- 4.0+ rating is table stakes — below that kills conversion

## Viral Growth Loops
- Share mechanic must create value for sender — "invite friend, both get reward"
- Shareable outputs: receipts, achievements, results with app branding
- Referral codes tracked per user — measure viral coefficient
- Time-to-invite: shorten the path to first share
- Deep links into app content — don't send users to app store if already installed

## Monetization
- Subscription > one-time purchase for retention — recurring revenue compounds
- Free trial: 7 days converts better than 3, worse than 14 — test for your app
- Paywall placement: after value demonstrated, before frustration
- Price testing: same app can 3x revenue with right price point
- Introductory offers for annual plans — lock in commitment

## Paid Acquisition
- Apple Search Ads: high intent, expensive — use for brand defense and discovery terms
- Reinvest profits into UA immediately — compound growth
- Track LTV:CAC ratio — must be > 3:1 for sustainability
- Creative fatigue is real — refresh ads every 2-4 weeks
- Lookalike audiences from paying users, not just installers

## Retention
- Push notification on day 1, 3, 7 — re-engage before they forget
- Streak mechanics for daily apps — habit formation
- Onboarding must reach "aha moment" in first session
- Track cohort retention curves — where's the drop-off?
- Reactivation campaigns cheaper than new acquisition

## Launch Strategy
- Soft launch in small market first — fix bugs, optimize funnel
- Coordinate launch: press, Product Hunt, social all same day
- Feature request: relationship with App Store team matters
- Pre-orders (iOS) build day-one momentum

## Common Mistakes
- Building features before fixing retention — more features won't fix churn
- Spending on ads with broken onboarding — paying for users who leave
- Ignoring Android — 70% of global market
- Review prompt on first launch — user hasn't experienced value yet
- Competing on keywords you can't win — long-tail converts better
