---
name: app-builder
description: Build, edit, and deploy Instant-backed apps using npx instant-cli, create-instant-app (Next.js + Codex), GitHub (gh), and Vercel (vercel). Use when asked to create a new app, modify an existing app, fix bugs, add features, or deploy/update an app. Projects live under ~/apps; always work inside the relevant app folder.
---

# App Builder

You have access to:
- `npx instant-cli`
- `gh` 
- `vercel`

If you use these tools, and find out that you don't have them or are not logged in, prompt the user to install them and log in. 

All apps live in: `~/apps`

## Ground rules

- Always create/edit projects in `~/apps/<app-name>`.
- Before making changes, read `AGENTS.md` in the repo root; also read `~/apps/<app-name>/AGENTS.md` if it exists.
- For now, always push to `main`.
- Every app must be:
  1) pushed to GitHub
  2) deployed on Vercel

## Workflow: create a new app

1. **Pick an app folder name**
   - Ensure `~/apps` exists.
   - The project will end up at `~/apps/<app-name>`.

2. **Create an Instant appId + token**
   - Run:
     - `npx instant-cli init-without-files`
   - Capture the returned `appId` and `token`.

3. **Generate the Next.js app**
   - Run this from inside `~/apps` (because the command creates the project folder):
     - `cd ~/apps`
     - `npx create-instant-app <app-name> --next --codex --app <appId> --token <token>`

4. **Initialise git + GitHub repo (if needed)**
   - From `~/apps/<app-name>`:
     - `git init` (if not already)
     - `git add -A && git commit -m "Init"` (if needed)
     - `gh repo create <repo-name> --private --source . --remote origin --push`
       - Use `--public` if the user requests.

5. **Vercel: create/link project and deploy**
   - From `~/apps/<app-name>`:
     - `vercel link` (or `vercel project add` / `vercel` depending on prompts)
     - `vercel --prod`

6. **Implement requested changes**
   - Use a coding agent (Codex CLI or equivalent) from within the app directory to make changes.
   - Prefer small, reviewable commits.

7. **Commit + push (main)**
   - `git add -A`
   - `git commit -m "<clear message>"`
   - `git push -u origin main`

8. **Deploy update**
   - `vercel --prod`

## Workflow: edit an existing app

1. `cd ~/apps/<app-name>`
2. Read relevant `AGENTS.md`.
3. Pull latest:
   - `git checkout main && git pull`
4. Make changes via coding agent / normal edits.
5. Test/build as appropriate.
6. Commit + push to `main`.
7. Deploy to Vercel (`vercel --prod`).

## Environment variables (.env)

When you first push to vercel, it likely won't have environment variables. Use the CLI to push the environment variables you do have in the local .env file.

## Notes / guardrails

- If `create-instant-app` created the repo + remote already, do not re-create it—just ensure `origin` exists and `main` is pushed.
- If Vercel is already linked, do not re-link—just deploy.

## Communicating 

When you start using this skill, send a message saying "Okay, getting ready to use my app builder skill". 

Then send period updates as you make progress. Building an app takes a while. Make it fun for the user.
